"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiStepNumberStyles = exports.euiStepNumberContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _step = require("./step.styles");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "76s2de-loading",
  styles: "background:transparent;label:loading;"
} : {
  name: "76s2de-loading",
  styles: "background:transparent;label:loading;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1ru1jeq-euiStepNumber",
  styles: "flex-shrink:0;label:euiStepNumber;"
} : {
  name: "1ru1jeq-euiStepNumber",
  styles: "flex-shrink:0;label:euiStepNumber;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiStepNumberStyles = exports.euiStepNumberStyles = function euiStepNumberStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = (0, _step.euiStepVariables)(euiTheme);
  var createStepsNumber = function createStepsNumber(size, fontSize) {
    return "\n      display: inline-block;\n      line-height: ".concat(size, ";\n      border-radius: ").concat(size, ";\n      ").concat((0, _global_styling.logicalCSS)('width', size), ";\n      ").concat((0, _global_styling.logicalCSS)('height', size), ";\n      text-align: center;\n      color: ").concat(euiTheme.colors.emptyShade, ";\n      background-color: ").concat(euiTheme.colors.primary, ";\n      font-size: ").concat(fontSize, ";\n      font-weight: ").concat(euiTheme.font.weight.medium, ";\n    ");
  };
  return {
    euiStepNumber: _ref2,
    // sizes
    m: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberSize, (0, _global_styling.euiFontSizeFromScale)('s', euiTheme)), ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberSize, (0, _global_styling.euiFontSizeFromScale)('s', euiTheme)), ";;label:s;"),
    xs: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberXSSize, (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme)), ";;label:xs;"),
    none: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberXXSSize, (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme)), ";;label:none;"),
    // status
    incomplete: /*#__PURE__*/(0, _react.css)("background-color:transparent;color:", euiTheme.colors.text, ";border:", euiTheme.border.thick, ";;label:incomplete;"),
    disabled: /*#__PURE__*/(0, _react.css)((0, _mixins.euiButtonFillColor)(euiThemeContext, 'disabled'), ";;label:disabled;"),
    loading: _ref,
    warning: /*#__PURE__*/(0, _react.css)((0, _mixins.euiButtonFillColor)(euiThemeContext, 'warning'), " ", _global_styling.euiCanAnimate, "{animation:", _global_styling.euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)((0, _mixins.euiButtonFillColor)(euiThemeContext, 'danger'), " ", _global_styling.euiCanAnimate, "{animation:", _global_styling.euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:danger;"),
    complete: /*#__PURE__*/(0, _react.css)((0, _mixins.euiButtonFillColor)(euiThemeContext, 'success'), " ", _global_styling.euiCanAnimate, "{animation:", _global_styling.euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:complete;"),
    current: /*#__PURE__*/(0, _react.css)("border:", euiTheme.border.width.thick, " solid ", euiTheme.colors.body, ";box-shadow:0 0 0 ", euiTheme.border.width.thick, " ", euiTheme.colors.primary, ";;label:current;")
  };
};
var euiStepNumberContentStyles = exports.euiStepNumberContentStyles = function euiStepNumberContentStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    // Statuses with icon content
    euiStepNumber__icon: /*#__PURE__*/(0, _react.css)("vertical-align:middle;position:relative;inset-block-start:-", euiTheme.border.width.thin, ";;label:euiStepNumber__icon;"),
    complete: /*#__PURE__*/(0, _react.css)("stroke:currentColor;stroke-width:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x / 2;
    }), ";;label:complete;"),
    danger: /*#__PURE__*/(0, _react.css)("stroke:currentColor;stroke-width:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x / 2;
    }), ";;label:danger;"),
    warning: /*#__PURE__*/(0, _react.css)("inset-block-start:-", euiTheme.border.width.thick, ";;label:warning;"),
    // Statuses with number content
    euiStepNumber__number: /*#__PURE__*/(0, _react.css)(";label:euiStepNumber__number;"),
    incomplete: /*#__PURE__*/(0, _react.css)("display:unset;position:relative;inset-block-start:-", euiTheme.border.width.thick, ";;label:incomplete;"),
    loading: /*#__PURE__*/(0, _react.css)(";label:loading;"),
    disabled: /*#__PURE__*/(0, _react.css)(";label:disabled;"),
    current: /*#__PURE__*/(0, _react.css)("display:inline-block;transform:translateY(-", euiTheme.border.width.thick, ");;label:current;"),
    none: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.s), ";label:none;")
  };
};