"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStat = exports.COLORS = exports.ALIGNMENTS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _text = require("../text");
var _title = require("../title/title");
var _accessibility = require("../accessibility");
var _i18n = require("../i18n");
var _services = require("../../services");
var _stat = require("./stat.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var COLORS = exports.COLORS = ['default', 'subdued', 'primary', 'success', 'danger', 'accent'];
var ALIGNMENTS = exports.ALIGNMENTS = ['left', 'center', 'right'];
var EuiStat = exports.EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
    className = _ref.className,
    description = _ref.description,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$reverse = _ref.reverse,
    reverse = _ref$reverse === void 0 ? false : _ref$reverse,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
    title = _ref.title,
    _ref$titleColor = _ref.titleColor,
    titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$descriptionEleme = _ref.descriptionElement,
    descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _stat.euiStatStyles)();
  var cssStyles = [styles.euiStat, styles[textAlign]];
  var classes = (0, _classnames.default)('euiStat', className);
  var commonProps = {
    'aria-hidden': true
  };
  var descriptionDisplay = (0, _react2.jsx)(_text.EuiText, {
    size: "s",
    className: "euiStat__description"
  }, /*#__PURE__*/(0, _react.createElement)(descriptionElement, commonProps, description));
  var isNamedTitleColor = COLORS.includes(titleColor);
  var titleStyles = (0, _stat.euiStatTitleStyles)(euiTheme);
  var titleCssStyles = [titleStyles.euiStat__title, isNamedTitleColor && titleStyles[titleColor], isLoading && titleStyles.isLoading];
  var titleProps = isNamedTitleColor ? commonProps : _objectSpread(_objectSpread({}, commonProps), {}, {
    style: {
      color: titleColor
    }
  });
  var titleChildren = isLoading ? '--' : title;
  var titleDisplay = (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize,
    className: "euiStat__title",
    css: titleCssStyles
  }, /*#__PURE__*/(0, _react.createElement)(titleElement, titleProps, titleChildren));
  var screenReader = (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, isLoading ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiStat.loadingText",
    default: "Statistic is loading"
  }) : (0, _react2.jsx)(_react.Fragment, null, reverse ? "".concat(title, " ").concat(description) : "".concat(description, " ").concat(title))));
  var statDisplay = (0, _react2.jsx)(_react.Fragment, null, !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, typeof title === 'string' && typeof description === 'string' && screenReader);
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), statDisplay, children);
};
EuiStat.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Set the description (label) text
     */
  description: _propTypes.default.node.isRequired,
  /**
     * Will hide the title with an animation until false
     */
  isLoading: _propTypes.default.bool,
  /**
     * Flips the order of the description and title
     */
  reverse: _propTypes.default.bool,
  textAlign: _propTypes.default.any,
  /**
     * The (value) text
     */
  title: _propTypes.default.node.isRequired,
  /**
     * The color of the title text
     */
  titleColor: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Size of the title. See EuiTitle for options ('s', 'm', 'l'... etc)
     */
  titleSize: _propTypes.default.any,
  /**
     * HTML Element to be used for title
     */
  titleElement: _propTypes.default.string,
  /**
     * HTML Element to be used for description
     */
  descriptionElement: _propTypes.default.string
};