"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSelectableTemplateSitewideRenderOptions = exports.euiSelectableTemplateSitewideFormatOptions = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../../../components/icon");
var _avatar = require("../../../components/avatar/avatar");
var _highlight = require("../../../components/highlight");
var _react2 = require("@emotion/react");
var _excluded = ["text", "highlightSearchString", "className"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /**
 * The generic extension allows consumers to keep their data objects
 * intact without needing to do key lookups when using `renderOption`
 */
var euiSelectableTemplateSitewideFormatOptions = exports.euiSelectableTemplateSitewideFormatOptions = function euiSelectableTemplateSitewideFormatOptions(options) {
  return options.map(function (item) {
    var title = item.label;
    if (item.meta && item.meta.length) {
      title += " \u2022".concat(renderOptionMeta(item.meta, '', true));
    }
    return _objectSpread(_objectSpread({
      key: item.label,
      title: title
    }, item), {}, {
      className: (0, _classnames.default)('euiSelectableTemplateSitewide__listItem', item.className),
      prepend: item.icon ? (0, _react2.jsx)(_icon.EuiIcon, _extends({
        color: "subdued",
        size: "l"
      }, item.icon)) : item.prepend,
      append: item.avatar ? (0, _react2.jsx)(_avatar.EuiAvatar, _extends({
        type: "space",
        size: "s"
      }, item.avatar)) : item.append
    });
  });
};
var euiSelectableTemplateSitewideRenderOptions = exports.euiSelectableTemplateSitewideRenderOptions = function euiSelectableTemplateSitewideRenderOptions(option, searchValue) {
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_highlight.EuiHighlight, {
    className: "euiSelectableTemplateSitewide__listItemTitle",
    search: searchValue
  }, option.label), renderOptionMeta(option.meta, searchValue));
};
function renderOptionMeta(meta) {
  var searchValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var stringsOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (!meta || meta.length < 1) return;
  var metas = meta.map(function (meta) {
    var text = meta.text,
      highlightSearchString = meta.highlightSearchString,
      className = meta.className,
      rest = _objectWithoutProperties(meta, _excluded);
    if (stringsOnly) {
      return " ".concat(text);
    }

    // Start with the base and custom classes
    var metaClasses = (0, _classnames.default)('euiSelectableTemplateSitewide__optionMeta', className);

    // If they provided a type, create the class and append
    if (meta.type) {
      metaClasses = (0, _classnames.default)(["euiSelectableTemplateSitewide__optionMeta--".concat(meta.type)], metaClasses);
    }
    return (0, _react2.jsx)(_highlight.EuiHighlight, _extends({
      search: highlightSearchString ? searchValue : '',
      className: metaClasses,
      key: text
    }, rest), text);
  });
  return stringsOnly ? metas : (0, _react2.jsx)("span", {
    className: "euiSelectableTemplateSitewide__optionMetasList"
  }, metas);
}