"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSearchBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _form = require("../form");
var _popover = require("../popover");
var _react2 = require("@emotion/react");
var _excluded = ["query", "placeholder", "incremental", "hint"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiSearchBox = exports.EuiSearchBox = function EuiSearchBox(_ref) {
  var query = _ref.query,
    placeholder = _ref.placeholder,
    incremental = _ref.incremental,
    hint = _ref.hint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _inputRef = (0, _react.useRef)(null);
  (0, _services.useUpdateEffect)(function () {
    if (_inputRef.current) {
      _inputRef.current.value = query;
      _inputRef.current.dispatchEvent(new Event('change'));
    }
  }, [query]);
  var defaultPlaceholder = (0, _i18n.useEuiI18n)('euiSearchBox.placeholder', 'Search...');
  var ariaLabelIncremental = (0, _i18n.useEuiI18n)('euiSearchBox.incrementalAriaLabel', 'This is a search bar. As you type, the results lower in the page will automatically filter.');
  var ariaLabelEnter = (0, _i18n.useEuiI18n)('euiSearchBox.ariaLabel', 'This is a search bar. After typing your query, hit enter to filter the results lower in the page.');
  var search = (0, _react2.jsx)(_form.EuiFieldSearch, _extends({
    inputRef: function inputRef(input) {
      return _inputRef.current = input;
    },
    fullWidth: true,
    defaultValue: query,
    incremental: incremental,
    "aria-label": incremental ? ariaLabelIncremental : ariaLabelEnter,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : defaultPlaceholder,
    onFocus: function onFocus() {
      hint === null || hint === void 0 || hint.setIsVisible(true);
    }
  }, rest));
  if (hint) {
    return (0, _react2.jsx)(_popover.EuiInputPopover, _extends({
      disableFocusTrap: true,
      input: search,
      isOpen: hint.isVisible,
      fullWidth: true,
      closePopover: function closePopover() {
        hint.setIsVisible(false);
      },
      panelProps: {
        'aria-live': undefined,
        'aria-modal': undefined,
        role: undefined,
        tabIndex: -1,
        id: hint.id
      }
    }, hint.popoverProps), hint.content);
  }
  return search;
};
EuiSearchBox.propTypes = {
  query: _propTypes.default.string.isRequired,
  // This is optional in EuiFieldSearchProps
  onSearch: _propTypes.default.func.isRequired,
  /**
     * @default Search...
     */
  placeholder: _propTypes.default.string,
  hint: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    isVisible: _propTypes.default.bool.isRequired,
    setIsVisible: _propTypes.default.func.isRequired,
    content: _propTypes.default.node.isRequired,
    popoverProps: _propTypes.default.any
  })
};