"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Ast", {
  enumerable: true,
  get: function get() {
    return _query2.AST;
  }
});
exports.EuiSearchBar = void 0;
Object.defineProperty(exports, "Query", {
  enumerable: true,
  get: function get() {
    return _query2.Query;
  }
});
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _predicate = require("../../services/predicate");
var _flex = require("../flex");
var _search_box = require("./search_box");
var _search_filters = require("./search_filters");
var _query2 = require("./query");
var _search_bar = require("./search_bar.styles");
var _react2 = require("@emotion/react");
var _excluded = ["schema"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var parseQuery = function parseQuery(query, props) {
  var schema = undefined;
  if (props.box && props.box.schema && _typeof(props.box.schema) === 'object') {
    schema = props.box.schema;
  }
  var dateFormat = props.dateFormat;
  var parseOptions = {
    schema: schema,
    dateFormat: dateFormat
  };
  if (!query) {
    return _query2.Query.parse('', parseOptions);
  }
  return (0, _predicate.isString)(query) ? _query2.Query.parse(query, parseOptions) : query;
};
var EuiSearchBar = exports.EuiSearchBar = /*#__PURE__*/function (_Component) {
  function EuiSearchBar(props) {
    var _this;
    _classCallCheck(this, EuiSearchBar);
    _this = _callSuper(this, EuiSearchBar, [props]);
    _defineProperty(_this, "hintId", (0, _services.htmlIdGenerator)('__hint')());
    _defineProperty(_this, "onSearch", function (queryText) {
      try {
        var query = parseQuery(queryText, _this.props);
        _this.notifyControllingParent({
          query: query,
          queryText: queryText,
          error: null
        });
        _this.setState({
          query: query,
          queryText: queryText,
          error: null
        });
      } catch (e) {
        var error = e instanceof Error ? {
          name: e.name,
          message: e.message
        } : {
          name: 'Unexpected error',
          message: String(e)
        };
        _this.notifyControllingParent({
          query: null,
          queryText: queryText,
          error: error
        });
        _this.setState({
          queryText: queryText,
          error: error
        });
      }
    });
    _defineProperty(_this, "onFiltersChange", function (query) {
      _this.notifyControllingParent({
        query: query,
        queryText: query.text,
        error: null
      });
      _this.setState({
        query: query,
        queryText: query.text,
        error: null
      });
    });
    var _query = parseQuery(props.defaultQuery || props.query, props);
    _this.state = {
      query: _query,
      queryText: _query.text,
      error: null,
      isHintVisible: false
    };
    return _this;
  }
  _inherits(EuiSearchBar, _Component);
  return _createClass(EuiSearchBar, [{
    key: "notifyControllingParent",
    value: function notifyControllingParent(newState) {
      var onChange = this.props.onChange;
      if (!onChange) {
        return;
      }
      var oldState = this.state;
      var query = newState.query,
        queryText = newState.queryText,
        error = newState.error;
      var isQueryDifferent = oldState.queryText !== queryText;
      var oldError = oldState.error ? oldState.error.message : null;
      var newError = error ? error.message : null;
      var isErrorDifferent = oldError !== newError;
      if (isQueryDifferent || isErrorDifferent) {
        if (error == null) {
          onChange({
            query: query,
            queryText: queryText,
            error: error
          });
        } else {
          onChange({
            query: null,
            queryText: queryText,
            error: error
          });
        }
      }
    }
  }, {
    key: "renderTools",
    value: function renderTools(tools) {
      if (!tools) {
        return undefined;
      }
      if (Array.isArray(tools)) {
        return tools.map(function (tool) {
          return (0, _react2.jsx)(_flex.EuiFlexItem, {
            grow: false,
            key: tool.key == null ? undefined : tool.key
          }, tool);
        });
      }
      return (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false
      }, tools);
    }
  }, {
    key: "render",
    value: function render() {
      var _hint$popoverProps$is,
        _hint$popoverProps,
        _this2 = this;
      var _this$state = this.state,
        query = _this$state.query,
        queryText = _this$state.queryText,
        error = _this$state.error,
        isHintVisibleState = _this$state.isHintVisible;
      var _this$props = this.props,
        _this$props$box = _this$props.box,
        _this$props$box2 = _this$props$box === void 0 ? {
          schema: ''
        } : _this$props$box,
        schema = _this$props$box2.schema,
        box = _objectWithoutProperties(_this$props$box2, _excluded),
        filters = _this$props.filters,
        toolsLeft = _this$props.toolsLeft,
        toolsRight = _this$props.toolsRight,
        hint = _this$props.hint;
      var toolsLeftEl = this.renderTools(toolsLeft);
      var toolsRightEl = this.renderTools(toolsRight);
      var isHintVisible = (_hint$popoverProps$is = hint === null || hint === void 0 || (_hint$popoverProps = hint.popoverProps) === null || _hint$popoverProps === void 0 ? void 0 : _hint$popoverProps.isOpen) !== null && _hint$popoverProps$is !== void 0 ? _hint$popoverProps$is : isHintVisibleState;
      return (0, _react2.jsx)(_services.RenderWithEuiTheme, null, function (euiTheme) {
        return (0, _react2.jsx)(_flex.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center",
          wrap: true
        }, toolsLeftEl, (0, _react2.jsx)(_flex.EuiFlexItem, {
          className: "euiSearchBar__searchHolder",
          css: (0, _search_bar.euiSearchBar__searchHolder)(euiTheme),
          grow: true
        }, (0, _react2.jsx)(_search_box.EuiSearchBox, _extends({}, box, {
          query: queryText,
          onSearch: _this2.onSearch,
          isInvalid: error != null,
          title: error ? error.message : undefined,
          "aria-describedby": isHintVisible ? "".concat(_this2.hintId) : undefined,
          hint: hint ? _objectSpread({
            isVisible: isHintVisible,
            setIsVisible: function setIsVisible(isVisible) {
              _this2.setState({
                isHintVisible: isVisible
              });
            },
            id: _this2.hintId
          }, hint) : undefined
        }))), filters && (0, _react2.jsx)(_flex.EuiFlexItem, {
          className: "euiSearchBar__filtersHolder",
          css: (0, _search_bar.euiSearchBar__filtersHolder)(euiTheme),
          grow: false
        }, (0, _react2.jsx)(_search_filters.EuiSearchBarFilters, {
          filters: filters,
          query: query,
          onChange: _this2.onFiltersChange
        })), toolsRightEl);
      });
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if ((nextProps.query || nextProps.query === '') && (!prevState.query || typeof nextProps.query !== 'string' && nextProps.query.text !== prevState.query.text || typeof nextProps.query === 'string' && nextProps.query !== prevState.query.text)) {
        var query = parseQuery(nextProps.query, nextProps);
        return {
          query: query,
          queryText: query.text,
          error: null,
          isHintVisible: prevState.isHintVisible
        };
      }
      return null;
    }
  }]);
}(_react.Component);
_defineProperty(EuiSearchBar, "Query", _query2.Query);
EuiSearchBar.propTypes = {
  onChange: _propTypes.default.func,
  /**
     The initial query the bar will hold when first mounted
     */
  defaultQuery: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
  /**
     If you wish to use the search bar as a controlled component, continuously pass the query via this prop.
     */
  query: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired]),
  /**
     Configures the search box. Set `placeholder` to change the placeholder text in the box and `incremental` to support incremental (as you type) search.
     */
  box: _propTypes.default.shape({
    name: _propTypes.default.string,
    id: _propTypes.default.string,
    placeholder: _propTypes.default.string,
    value: _propTypes.default.string,
    isInvalid: _propTypes.default.bool,
    /**
       * Expand to fill 100% of the parent.
       * Defaults to `fullWidth` prop of `<EuiForm>`.
       * @default false
       */
    fullWidth: _propTypes.default.bool,
    isLoading: _propTypes.default.bool,
    /**
       * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
       * If you don't need the on[Enter] functionality, prefer using onChange
       */
    onSearch: _propTypes.default.func,
    /**
       * When `true` the search will be executed (that is, the `onSearch` will be called) as the
       * user types.
       */
    incremental: _propTypes.default.bool,
    /**
       * when `true` creates a shorter height input
       */
    compressed: _propTypes.default.bool,
    inputRef: _propTypes.default.func,
    /**
       * Shows a button that quickly clears any input
       */
    isClearable: _propTypes.default.bool,
    /**
       * Creates an input group with element(s) coming before input
       * `string` | `ReactElement` or an array of these
       */
    prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
    /**
       * Creates an input group with element(s) coming after input.
       * `string` | `ReactElement` or an array of these
       */
    append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any,
    // Boolean values are not meaningful to this EuiSearchBox, but are allowed so that other
    // components can use e.g. a true value to mean "auto-derive a schema". See EuiInMemoryTable.
    // Admittedly, this is a bit of a hack.
    schema: _propTypes.default.oneOfType([_propTypes.default.shape({
      strict: _propTypes.default.bool,
      fields: _propTypes.default.any,
      flags: _propTypes.default.arrayOf(_propTypes.default.string.isRequired)
    }).isRequired, _propTypes.default.bool.isRequired])
  }),
  /**
     An array of search filters. See #SearchFilterConfig.
     */
  filters: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    type: _propTypes.default.oneOf(["is"]).isRequired,
    field: _propTypes.default.string.isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_selection"]).isRequired,
    field: _propTypes.default.string,
    name: _propTypes.default.string.isRequired,
    /**
       * See #FieldValueOptionType
       */
    options: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
      field: _propTypes.default.string,
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
        type: _propTypes.default.oneOf(["date"]).isRequired,
        raw: _propTypes.default.any.isRequired,
        granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
          es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
          js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: _propTypes.default.func.isRequired,
          start: _propTypes.default.func.isRequired,
          startOfNext: _propTypes.default.func.isRequired,
          iso8601: _propTypes.default.func.isRequired
        }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
        text: _propTypes.default.string.isRequired,
        resolve: _propTypes.default.func.isRequired
      }).isRequired]).isRequired,
      name: _propTypes.default.string,
      view: _propTypes.default.node
    }).isRequired).isRequired, _propTypes.default.func.isRequired]).isRequired,
    filterWith: _propTypes.default.oneOfType([_propTypes.default.oneOf(["prefix", "includes"]), _propTypes.default.func.isRequired]),
    cache: _propTypes.default.number,
    multiSelect: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["and", "or"])]),
    loadingMessage: _propTypes.default.string,
    noOptionsMessage: _propTypes.default.string,
    searchThreshold: _propTypes.default.number,
    available: _propTypes.default.func,
    autoClose: _propTypes.default.bool,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle"]).isRequired,
    field: _propTypes.default.string.isRequired,
    value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
      type: _propTypes.default.oneOf(["date"]).isRequired,
      raw: _propTypes.default.any.isRequired,
      granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
        es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
        js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
        isSame: _propTypes.default.func.isRequired,
        start: _propTypes.default.func.isRequired,
        startOfNext: _propTypes.default.func.isRequired,
        iso8601: _propTypes.default.func.isRequired
      }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
      text: _propTypes.default.string.isRequired,
      resolve: _propTypes.default.func.isRequired
    }).isRequired]).isRequired,
    name: _propTypes.default.string.isRequired,
    negatedName: _propTypes.default.string,
    available: _propTypes.default.func,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_toggle_group"]).isRequired,
    field: _propTypes.default.string.isRequired,
    /**
       * See #FieldValueToggleGroupFilterItemType
       */
    items: _propTypes.default.arrayOf(_propTypes.default.shape({
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired]).isRequired,
      name: _propTypes.default.string.isRequired,
      negatedName: _propTypes.default.string,
      operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired).isRequired,
    available: _propTypes.default.func
  }).isRequired, _propTypes.default.shape({
    type: _propTypes.default.oneOf(["custom_component"]).isRequired,
    component: _propTypes.default.elementType.isRequired,
    available: _propTypes.default.func
  }).isRequired]).isRequired),
  /**
     * Tools which go to the left of the search bar.
     */
  toolsLeft: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired]),
  /**
     * Tools which go to the right of the search bar.
     */
  toolsRight: _propTypes.default.oneOfType([_propTypes.default.element.isRequired, _propTypes.default.arrayOf(_propTypes.default.element.isRequired).isRequired]),
  /**
     * Date formatter to use when parsing date values
     */
  dateFormat: _propTypes.default.any,
  /**
     * Hint to render below the search bar
     */
  hint: _propTypes.default.shape({
    content: _propTypes.default.node.isRequired,
    popoverProps: _propTypes.default.any
  }),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};