"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueSelectionFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _predicate = require("../../../services/predicate");
var _popover = require("../../popover");
var _filter_group = require("../../filter_group");
var _filter_group2 = require("../../filter_group/filter_group.styles");
var _selectable = require("../../selectable");
var _query4 = require("../query");
var _ast = require("../query/ast");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var defaults = {
  config: {
    multiSelect: true,
    filterWith: 'prefix',
    searchThreshold: 10
  }
};
var FieldValueSelectionFilter = exports.FieldValueSelectionFilter = /*#__PURE__*/function (_Component) {
  function FieldValueSelectionFilter(props) {
    var _this;
    _classCallCheck(this, FieldValueSelectionFilter);
    _this = _callSuper(this, FieldValueSelectionFilter, [props]);
    _defineProperty(_this, "resolveOptionsLoader", function () {
      var options = _this.props.config.options;
      if ((0, _predicate.isArray)(options)) {
        return function () {
          return Promise.resolve(options);
        };
      }
      return function () {
        var cachedOptions = _this.state.cachedOptions;
        if (cachedOptions) {
          return Promise.resolve(cachedOptions);
        }
        return options().then(function (opts) {
          // If a cache time is set, populate the cache and also schedule a
          // cache reset.
          if (_this.props.config.cache != null && _this.props.config.cache > 0) {
            _this.setState({
              cachedOptions: opts
            });
            setTimeout(function () {
              _this.setState({
                cachedOptions: null
              });
            }, _this.props.config.cache);
          }
          return opts;
        });
      };
    });
    var _options = props.config.options;
    var preloadedOptions = (0, _predicate.isArray)(_options) ? {
      all: _options,
      shown: _options
    } : null;
    _this.state = {
      popoverOpen: false,
      error: null,
      options: preloadedOptions,
      activeItems: []
    };
    return _this;
  }
  _inherits(FieldValueSelectionFilter, _Component);
  return _createClass(FieldValueSelectionFilter, [{
    key: "closePopover",
    value: function closePopover() {
      this.setState({
        popoverOpen: false
      });
    }
  }, {
    key: "onButtonClick",
    value: function onButtonClick() {
      var _this2 = this;
      this.setState(function (prevState) {
        if (!prevState.popoverOpen) {
          // loading options updates the state, so we'll do that in the animation frame
          window.requestAnimationFrame(function () {
            _this2.loadOptions();
          });
        }
        return {
          options: null,
          error: null,
          popoverOpen: !prevState.popoverOpen
        };
      });
    }
  }, {
    key: "loadOptions",
    value: function loadOptions() {
      var _this3 = this;
      var loader = this.resolveOptionsLoader();
      this.setState({
        options: null,
        error: null
      });
      loader().then(function (options) {
        var items = {
          on: [],
          off: [],
          rest: []
        };
        var _this3$props = _this3.props,
          query = _this3$props.query,
          config = _this3$props.config;
        var multiSelect = _this3.resolveMultiSelect();
        if (options) {
          options.forEach(function (op) {
            var optionField = op.field || config.field;
            if (optionField) {
              var clause = multiSelect === 'or' ? query.getOrFieldClause(optionField, op.value) : query.getSimpleFieldClause(optionField, op.value);
              var checked = _this3.resolveChecked(clause);
              if (!checked) {
                items.rest.push(op);
              } else if (checked === 'on') {
                items.on.push(op);
              } else {
                items.off.push(op);
              }
            }
            return;
          });
        }
        _this3.setState({
          error: null,
          activeItems: items.on,
          options: {
            all: options,
            shown: [].concat(_toConsumableArray(items.on), _toConsumableArray(items.off), _toConsumableArray(items.rest))
          }
        });
      }).catch(function () {
        _this3.setState({
          options: null,
          error: 'Could not load options'
        });
      });
    }
  }, {
    key: "filterOptions",
    value: function filterOptions() {
      var _this4 = this;
      var q = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      this.setState(function (prevState) {
        if ((0, _predicate.isNil)(prevState.options)) {
          return {};
        }
        var predicate = _this4.getOptionFilter();
        return _objectSpread(_objectSpread({}, prevState), {}, {
          options: _objectSpread(_objectSpread({}, prevState.options), {}, {
            shown: prevState.options.all.filter(function (option, i, options) {
              var name = _this4.resolveOptionName(option).toLowerCase();
              var query = q.toLowerCase();
              return predicate(name, query, options);
            })
          })
        });
      });
    }
  }, {
    key: "getOptionFilter",
    value: function getOptionFilter() {
      var filterWith = this.props.config.filterWith || defaults.config.filterWith;
      if (typeof filterWith === 'function') {
        return filterWith;
      }
      if (filterWith === 'includes') {
        return function (name, query) {
          return name.includes(query);
        };
      }
      return function (name, query) {
        return name.startsWith(query);
      };
    }
  }, {
    key: "resolveOptionName",
    value: function resolveOptionName(option) {
      return option.name || option.value.toString();
    }
  }, {
    key: "onOptionClick",
    value: function onOptionClick(field, value, checked) {
      var multiSelect = this.resolveMultiSelect();
      var _this$props$config = this.props.config,
        autoClose = _this$props$config.autoClose,
        _this$props$config$op = _this$props$config.operator,
        operator = _this$props$config$op === void 0 ? _ast.Operator.EQ : _this$props$config$op;

      // If the consumer explicitly sets `autoClose`, always defer to that.
      // Otherwise, default to auto-closing for single selections and leaving the
      // popover open for multi-select (so users can continue selecting options)
      var shouldClosePopover = autoClose !== null && autoClose !== void 0 ? autoClose : !multiSelect;
      if (shouldClosePopover) {
        this.closePopover();
      }
      if (!multiSelect) {
        var _query = checked ? this.props.query.removeSimpleFieldClauses(field).addSimpleFieldValue(field, value, true, operator) : this.props.query.removeSimpleFieldClauses(field);
        this.props.onChange(_query);
      } else if (multiSelect === 'or') {
        var _query2 = checked ? this.props.query.addOrFieldValue(field, value, true, operator) : this.props.query.removeOrFieldValue(field, value);
        this.props.onChange(_query2);
      } else {
        var _query3 = checked ? this.props.query.addSimpleFieldValue(field, value, true, operator) : this.props.query.removeSimpleFieldValue(field, value);
        this.props.onChange(_query3);
      }
    }
  }, {
    key: "resolveMultiSelect",
    value: function resolveMultiSelect() {
      var config = this.props.config;
      return !(0, _predicate.isNil)(config.multiSelect) ? config.multiSelect : defaults.config.multiSelect;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.query.text.length) this.loadOptions();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.query !== prevProps.query) this.loadOptions();
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;
      var _this$props = this.props,
        query = _this$props.query,
        config = _this$props.config;
      var multiSelect = this.resolveMultiSelect();
      var activeTop = this.isActiveField(config.field);
      var activeItem = this.state.options ? this.state.options.all.some(function (item) {
        return _this5.isActiveField(item.field);
      }) : false;
      var activeItemsCount = this.state.activeItems.length;
      var active = (activeTop || activeItem) && activeItemsCount > 0;
      var button = (0, _react2.jsx)(_filter_group.EuiFilterButton, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: this.onButtonClick.bind(this),
        hasActiveFilters: active,
        numActiveFilters: active ? activeItemsCount : undefined,
        grow: true
      }, config.name);
      var items = this.state.options ? this.state.options.shown.map(function (option) {
        var _option$view;
        var optionField = option.field || config.field;
        if (optionField == null) {
          throw new Error('option.field or field should be provided in <FieldValueSelectionFilter/>');
        }
        var clause = multiSelect === 'or' ? query.getOrFieldClause(optionField, option.value) : query.getSimpleFieldClause(optionField, option.value);
        var label = _this5.resolveOptionName(option);
        var checked = _this5.resolveChecked(clause);
        return {
          label: label,
          checked: checked,
          data: {
            view: (_option$view = option.view) !== null && _option$view !== void 0 ? _option$view : label,
            value: option.value,
            optionField: optionField
          }
        };
      }) : [];
      var threshold = config.searchThreshold || defaults.config.searchThreshold;
      var isOverSearchThreshold = this.state.options && this.state.options.all.length >= threshold;
      var searchProps = {
        searchable: false
      };
      if (isOverSearchThreshold) {
        searchProps = {
          searchable: true,
          searchProps: {
            compressed: true,
            disabled: this.state.error != null
          }
        };
      }
      return (0, _react2.jsx)(_services.RenderWithEuiTheme, null, function (euiThemeContext) {
        return (0, _react2.jsx)(_popover.EuiPopover, {
          button: button,
          isOpen: _this5.state.popoverOpen,
          closePopover: _this5.closePopover.bind(_this5),
          panelPaddingSize: "none",
          anchorPosition: "downCenter",
          panelProps: {
            css: (0, _filter_group2.euiFilterGroupStyles)(euiThemeContext).euiFilterGroup__popoverPanel
          }
        }, (0, _react2.jsx)(_selectable.EuiSelectable, _extends({
          singleSelection: !multiSelect,
          "aria-label": config.name,
          options: items,
          renderOption: function renderOption(option) {
            return option.view;
          },
          isLoading: (0, _predicate.isNil)(_this5.state.options),
          loadingMessage: config.loadingMessage,
          emptyMessage: config.noOptionsMessage,
          errorMessage: _this5.state.error,
          noMatchesMessage: config.noOptionsMessage,
          listProps: {
            isVirtualized: isOverSearchThreshold || false
          },
          onChange: function onChange(options, event, changedOption) {
            if (changedOption.data) {
              _this5.onOptionClick(changedOption.data.optionField, changedOption.data.value, changedOption.checked);
            }
          }
        }, searchProps), function (list, search) {
          return (0, _react2.jsx)(_react.default.Fragment, null, isOverSearchThreshold && (0, _react2.jsx)(_popover.EuiPopoverTitle, {
            paddingSize: "s"
          }, search), list);
        }));
      });
    }
  }, {
    key: "resolveChecked",
    value: function resolveChecked(clause) {
      if (clause) {
        return _query4.Query.isMust(clause) ? 'on' : 'off';
      }
    }
  }, {
    key: "isActiveField",
    value: function isActiveField(field) {
      if (typeof field !== 'string') {
        return false;
      }
      var query = this.props.query;
      var multiSelect = this.resolveMultiSelect();
      if (multiSelect === 'or') {
        return query.hasOrFieldClause(field);
      }
      return query.hasSimpleFieldClause(field);
    }
  }]);
}(_react.Component);
FieldValueSelectionFilter.propTypes = {
  index: _propTypes.default.number.isRequired,
  config: _propTypes.default.shape({
    type: _propTypes.default.oneOf(["field_value_selection"]).isRequired,
    field: _propTypes.default.string,
    name: _propTypes.default.string.isRequired,
    /**
       * See #FieldValueOptionType
       */
    options: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.shape({
      field: _propTypes.default.string,
      value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired, _propTypes.default.bool.isRequired, _propTypes.default.shape({
        type: _propTypes.default.oneOf(["date"]).isRequired,
        raw: _propTypes.default.any.isRequired,
        granularity: _propTypes.default.oneOfType([_propTypes.default.shape({
          es: _propTypes.default.oneOf(["d", "w", "M", "y"]).isRequired,
          js: _propTypes.default.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: _propTypes.default.func.isRequired,
          start: _propTypes.default.func.isRequired,
          startOfNext: _propTypes.default.func.isRequired,
          iso8601: _propTypes.default.func.isRequired
        }).isRequired, _propTypes.default.oneOf([undefined])]).isRequired,
        text: _propTypes.default.string.isRequired,
        resolve: _propTypes.default.func.isRequired
      }).isRequired]).isRequired,
      name: _propTypes.default.string,
      view: _propTypes.default.node
    }).isRequired).isRequired, _propTypes.default.func.isRequired]).isRequired,
    filterWith: _propTypes.default.oneOfType([_propTypes.default.oneOf(["prefix", "includes"]), _propTypes.default.func.isRequired]),
    cache: _propTypes.default.number,
    multiSelect: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["and", "or"])]),
    loadingMessage: _propTypes.default.string,
    noOptionsMessage: _propTypes.default.string,
    searchThreshold: _propTypes.default.number,
    available: _propTypes.default.func,
    autoClose: _propTypes.default.bool,
    operator: _propTypes.default.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
  }).isRequired,
  query: _propTypes.default.any.isRequired,
  onChange: _propTypes.default.func.isRequired
};