"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizableCollapseButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _button = require("../button");
var _screen_reader_only = require("../accessibility/screen_reader_only/screen_reader_only.styles");
var _resizable_collapse_button = require("./resizable_collapse_button.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "externalPosition", "internalPosition", "direction", "isVisible", "isCollapsed"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiResizableCollapseButton = exports.EuiResizableCollapseButton = function EuiResizableCollapseButton(_ref) {
  var className = _ref.className,
    _ref$externalPosition = _ref.externalPosition,
    externalPosition = _ref$externalPosition === void 0 ? 'before' : _ref$externalPosition,
    _ref$internalPosition = _ref.internalPosition,
    internalPosition = _ref$internalPosition === void 0 ? 'middle' : _ref$internalPosition,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
    isVisible = _ref.isVisible,
    isCollapsed = _ref.isCollapsed,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHorizontal = direction === 'horizontal';
  var showOnFocus = !isCollapsed && !isVisible;
  var styles = (0, _services.useEuiMemoizedStyles)(_resizable_collapse_button.euiResizableCollapseButtonStyles);
  var collapsedStyles = [styles.collapsed.collapsed, styles.collapsed[direction], styles.collapsed["".concat(direction, "Positions")][internalPosition]];
  var collapsibleStyles = [styles.collapsible.collapsible, styles.collapsible[direction][externalPosition], styles.collapsible[direction][internalPosition]];
  var cssStyles = [styles.euiResizableCollapseButton, showOnFocus && _screen_reader_only.euiScreenReaderOnlyStyles['euiScreenReaderOnly-showOnFocus']].concat(_toConsumableArray(isCollapsed ? collapsedStyles : collapsibleStyles));
  var COLLAPSED_ICON = '';
  var NOT_COLLAPSED_ICON = '';
  switch (externalPosition) {
    case 'before':
      COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      break;
    case 'after':
      COLLAPSED_ICON = isHorizontal ? 'menuRight' : 'menuDown';
      NOT_COLLAPSED_ICON = isHorizontal ? 'menuLeft' : 'menuUp';
      break;
  }
  var classes = (0, _classnames.default)('euiResizableCollapseButton', className);
  return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
    display: isCollapsed ? 'empty' : 'base',
    color: "text",
    className: classes,
    css: cssStyles
  }, rest, {
    iconType: isCollapsed ? COLLAPSED_ICON : NOT_COLLAPSED_ICON
  }));
};
EuiResizableCollapseButton.propTypes = {
  /**
     * Position of the toggle button.
     * Enums based on the `direction` of the EuiResizableContainer
     */
  internalPosition: _propTypes.default.oneOf(["top", "middle", "bottom", "left", "right"]),
  /**
     * Position of the toggle button.
     * Enums based on the `direction` of the EuiResizableContainer
     */
  externalPosition: _propTypes.default.oneOf(["before", "after"]),
  /**
     * Same direction derived from EuiResizableContainer
     */
  direction: _propTypes.default.oneOf(["vertical", "horizontal"]),
  isVisible: _propTypes.default.bool,
  isCollapsed: _propTypes.default.bool
};