"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiInputPopoverWidthContext = exports.EuiInputPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _resize_observer = require("../observer/resize_observer");
var _focus_trap = require("../focus_trap");
var _form = require("../form/form.styles");
var _popover = require("./popover");
var _excluded = ["children", "className", "closePopover", "anchorPosition", "attachToAnchor", "repositionToCrossAxis", "display", "panelPaddingSize", "closeOnScroll", "ownFocus", "disableFocusTrap", "focusTrapProps", "input", "fullWidth", "panelMinWidth", "onPanelResize", "inputRef", "panelRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
// Used by child components that want to know the parent popover width
var EuiInputPopoverWidthContext = exports.EuiInputPopoverWidthContext = /*#__PURE__*/(0, _react.createContext)(0);
var EuiInputPopover = exports.EuiInputPopover = function EuiInputPopover(_ref) {
  var _props$panelProps;
  var children = _ref.children,
    className = _ref.className,
    closePopover = _ref.closePopover,
    _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'downLeft' : _ref$anchorPosition,
    _ref$attachToAnchor = _ref.attachToAnchor,
    attachToAnchor = _ref$attachToAnchor === void 0 ? true : _ref$attachToAnchor,
    _ref$repositionToCros = _ref.repositionToCrossAxis,
    repositionToCrossAxis = _ref$repositionToCros === void 0 ? false : _ref$repositionToCros,
    _ref$display = _ref.display,
    display = _ref$display === void 0 ? 'block' : _ref$display,
    _ref$panelPaddingSize = _ref.panelPaddingSize,
    panelPaddingSize = _ref$panelPaddingSize === void 0 ? 's' : _ref$panelPaddingSize,
    _ref$closeOnScroll = _ref.closeOnScroll,
    closeOnScroll = _ref$closeOnScroll === void 0 ? false : _ref$closeOnScroll,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? false : _ref$ownFocus,
    _ref$disableFocusTrap = _ref.disableFocusTrap,
    disableFocusTrap = _ref$disableFocusTrap === void 0 ? false : _ref$disableFocusTrap,
    focusTrapProps = _ref.focusTrapProps,
    input = _ref.input,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$panelMinWidth = _ref.panelMinWidth,
    panelMinWidth = _ref$panelMinWidth === void 0 ? 0 : _ref$panelMinWidth,
    onPanelResize = _ref.onPanelResize,
    _inputRef = _ref.inputRef,
    _panelRef = _ref.panelRef,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiInputPopover', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var form = (0, _form.euiFormVariables)(euiTheme);

  /**
   * Ref setup
   */

  var popoverClassRef = (0, _react.useRef)(null);
  // The inputEl state ensures that width is correctly tracked on initial load
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    inputEl = _useState2[0],
    setInputEl = _useState2[1];
  // The panelEl state ensures that width is correctly set every time the popover opens
  var _useState3 = (0, _react.useState)(null),
    _useState4 = _slicedToArray(_useState3, 2),
    panelEl = _useState4[0],
    setPanelEl = _useState4[1];
  var inputRef = (0, _services.useCombinedRefs)([setInputEl, _inputRef]);
  var panelRef = (0, _services.useCombinedRefs)([setPanelEl, _panelRef]);

  /**
   * Sizing/width logic
   */

  var inputWidth = (0, _resize_observer.useResizeObserver)(inputEl, 'width').width;
  var panelWidth = (0, _react.useMemo)(function () {
    return inputWidth < panelMinWidth ? panelMinWidth : inputWidth;
  }, [panelMinWidth, inputWidth]);

  // Resize callback
  (0, _react.useEffect)(function () {
    onPanelResize === null || onPanelResize === void 0 || onPanelResize(panelWidth);
  }, [panelWidth, onPanelResize]);
  (0, _react.useEffect)(function () {
    if (panelEl) {
      // We have to modify the popover panel DOM node directly instead of using
      // `panelStyle`, as there's some weird positioning bugs on resize otherwise
      panelEl.style.inlineSize = "".concat(panelWidth, "px");
    }
  }, [panelEl, panelWidth]);
  (0, _react.useEffect)(function () {
    // This fires on all input width changes regardless of minimum size, because on
    // right/center anchored popovers, the input width affects the position of the popover
    if (panelEl) {
      var _popoverClassRef$curr;
      (_popoverClassRef$curr = popoverClassRef.current) === null || _popoverClassRef$curr === void 0 || _popoverClassRef$curr.positionPopoverFluid();
    }
  }, [inputWidth, panelEl]);

  /**
   * Popover tab to close logic
   */

  var panelPropsOnKeyDown = (_props$panelProps = props.panelProps) === null || _props$panelProps === void 0 ? void 0 : _props$panelProps.onKeyDown;
  var onKeyDown = (0, _react.useCallback)(function (event) {
    panelPropsOnKeyDown === null || panelPropsOnKeyDown === void 0 || panelPropsOnKeyDown(event);
    if (event.key === _services.keys.TAB) {
      if (disableFocusTrap) {
        if (!ownFocus) {
          closePopover();
        }
      } else {
        var tabbableItems = (0, _tabbable.tabbable)(event.currentTarget).filter(function (el) {
          return !el.hasAttribute('data-focus-guard');
        });
        if (!tabbableItems.length) return;
        var tabbingFromLastItemInPopover = document.activeElement === tabbableItems[tabbableItems.length - 1];
        if (tabbingFromLastItemInPopover) {
          closePopover();
        }
      }
    }
  }, [disableFocusTrap, ownFocus, closePopover, panelPropsOnKeyDown]);

  /**
   * Optional close on scroll behavior
   */

  (0, _react.useEffect)(function () {
    // When the popover opens, add a scroll listener to the page (& remove it after)
    if (closeOnScroll && panelEl) {
      var closePopoverOnScroll = function closePopoverOnScroll(event) {
        var scrollTarget = event.target;

        // Basic existence check
        if (!panelEl || !inputEl || !scrollTarget) {
          return;
        }
        // Do not close the popover if the input or popover itself was scrolled
        if (panelEl.contains(scrollTarget) || inputEl.contains(scrollTarget)) {
          return;
        }
        // Firefox will trigger a scroll event in many common situations (e.g. docs side nav)
        // when the options list div is appended to the DOM. To work around this, we should
        // check if the element that scrolled actually contains/will affect the input
        if (!scrollTarget.contains(inputEl)) {
          return;
        }
        closePopover();
      };

      // Kibana Cypress tests trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe
      var timeoutId = setTimeout(function () {
        window.addEventListener('scroll', closePopoverOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead
        });
      }, 500);
      return function () {
        window.removeEventListener('scroll', closePopoverOnScroll, {
          capture: true
        });
        clearTimeout(timeoutId);
      };
    }
  }, [closeOnScroll, closePopover, panelEl, inputEl]);
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({
    className: classes,
    css: /*#__PURE__*/(0, _react2.css)(fullWidth ? undefined : (0, _global_styling.logicalCSS)('max-width', form.maxWidth), ";label:EuiInputPopover;"),
    display: display,
    button: input,
    popoverRef: inputRef,
    panelRef: panelRef,
    ref: popoverClassRef,
    closePopover: closePopover,
    anchorPosition: anchorPosition,
    attachToAnchor: attachToAnchor,
    repositionToCrossAxis: repositionToCrossAxis,
    panelPaddingSize: panelPaddingSize,
    ownFocus: ownFocus
  }, props, {
    panelProps: _objectSpread(_objectSpread({}, props.panelProps), {}, {
      onKeyDown: onKeyDown
    })
  }), (0, _react2.jsx)(_focus_trap.EuiFocusTrap, _extends({
    clickOutsideDisables: true,
    disabled: disableFocusTrap
  }, focusTrapProps), (0, _react2.jsx)(EuiInputPopoverWidthContext.Provider, {
    value: panelWidth
  }, children)));
};
EuiInputPopover.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Alignment of the popover relative to the input
     */
  anchorPosition: _propTypes.default.oneOf(["downLeft", "downRight", "downCenter"]),
  disableFocusTrap: _propTypes.default.bool,
  /**
     * Allows automatically closing the input popover on page scroll
     */
  closeOnScroll: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  input: _propTypes.default.any.isRequired,
  inputRef: _propTypes.default.any,
  onPanelResize: _propTypes.default.func,
  /**
     * By default, **EuiInputPopovers** inherit the same width as the passed input element.
     * However, if the input width is too small, you can pass a minimum panel width
     * (that should be based on the popover content).
     */
  panelMinWidth: _propTypes.default.number
};