"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeSliderThumbStyles = exports.euiRangeSliderStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _form = require("../form.styles");
var _range = require("./range.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeSliderStyles = exports.euiRangeSliderStyles = function euiRangeSliderStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    // Base
    euiRangeSlider: /*#__PURE__*/(0, _react.css)("appearance:none;background:transparent;inline-size:100%;block-size:100%;position:relative;cursor:pointer;z-index:", range.thumbZIndex, ";", (0, _range.euiRangeThumbPerBrowser)("\n        ".concat((0, _form.euiCustomControl)(euiThemeContext, {
      type: 'round'
    }), "\n        ").concat((0, _range.euiRangeThumbStyle)(euiThemeContext), "\n      ")), " &:disabled{cursor:not-allowed;", (0, _range.euiRangeThumbPerBrowser)('cursor: not-allowed'), ";}&::-webkit-slider-thumb{-webkit-appearance:none;}&:focus{outline:none;}&:focus-visible{", (0, _range.euiRangeThumbPerBrowser)((0, _range.euiRangeThumbFocus)(euiThemeContext)), " &~.euiRangeTooltip .euiRangeTooltip__value{transform:translateX(0) translateY(-50%) scale(1.1);}};label:euiRangeSlider;"),
    hasTicks: /*#__PURE__*/(0, _react.css)("block-size:", range.thumbHeight, ";;label:hasTicks;"),
    hasRange: /*#__PURE__*/(0, _react.css)((0, _range.euiRangeTrackPerBrowser)("\n        background-color: transparent;\n        border-color: ".concat((0, _services.transparentize)(range.trackBorderColor, 0.6), "\n      ")), ";;label:hasRange;"),
    hasLevels: /*#__PURE__*/(0, _react.css)((0, _range.euiRangeThumbPerBrowser)("background-color: ".concat(range.thumbBackgroundColor)), ";;label:hasLevels;")
  };
};
var euiRangeSliderThumbStyles = exports.euiRangeSliderThumbStyles = function euiRangeSliderThumbStyles(euiThemeContext) {
  return {
    thumb: /*#__PURE__*/(0, _react.css)((0, _range.euiRangeThumbPerBrowser)('background-color: currentcolor'), " &:focus-visible{", (0, _range.euiRangeThumbPerBrowser)((0, _range.euiRangeThumbFocus)(euiThemeContext, 'currentcolor')), ";};label:thumb;")
  };
};