"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormRow = exports.DISPLAYS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../../common");
var _objects = require("../../../services/objects");
var _form_help_text = require("../form_help_text");
var _form_error_text = require("../form_error_text");
var _form_label = require("../form_label");
var _eui_form_context = require("../eui_form_context");
var _accessibility = require("../../../services/accessibility");
var _react2 = require("@emotion/react");
var _excluded = ["children", "helpText", "isInvalid", "error", "label", "labelType", "labelAppend", "hasEmptyLabelSpace", "fullWidth", "className", "describedByIds", "display", "hasChildLabel", "id", "isDisabled"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var displayToClassNameMap = {
  row: null,
  rowCompressed: 'euiFormRow--compressed',
  columnCompressed: 'euiFormRow--compressed euiFormRow--horizontal',
  center: null,
  centerCompressed: 'euiFormRow--compressed',
  columnCompressedSwitch: 'euiFormRow--compressed euiFormRow--horizontal euiFormRow--hasSwitch'
};
var DISPLAYS = exports.DISPLAYS = (0, _common.keysOf)(displayToClassNameMap);
var EuiFormRow = exports.EuiFormRow = /*#__PURE__*/function (_Component) {
  function EuiFormRow() {
    var _this;
    _classCallCheck(this, EuiFormRow);
    for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
      _args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFormRow, [].concat(_args));
    _defineProperty(_this, "state", {
      isFocused: false,
      id: _this.props.id || (0, _accessibility.htmlIdGenerator)()()
    });
    _defineProperty(_this, "onFocus", function () {
      // Doing this to allow onFocus to be called correctly from the child input element as this component overrides it
      var onChildFocus = (0, _objects.get)(_this.props, 'children.props.onFocus');
      if (onChildFocus) {
        onChildFocus.apply(void 0, arguments);
      }
      _this.setState(function (_ref) {
        var isFocused = _ref.isFocused;
        if (!isFocused) {
          return {
            isFocused: true
          };
        } else {
          return null;
        }
      });
    });
    _defineProperty(_this, "onBlur", function () {
      // Doing this to allow onBlur to be called correctly from the child input element as this component overrides it
      var onChildBlur = (0, _objects.get)(_this.props, 'children.props.onBlur');
      if (onChildBlur) {
        onChildBlur.apply(void 0, arguments);
      }
      _this.setState({
        isFocused: false
      });
    });
    return _this;
  }
  _inherits(EuiFormRow, _Component);
  return _createClass(EuiFormRow, [{
    key: "render",
    value: function render() {
      var _ref3, _child$props$disabled;
      var _ref2 = this.context,
        defaultFullWidth = _ref2.defaultFullWidth;
      var _this$props = this.props,
        children = _this$props.children,
        helpText = _this$props.helpText,
        isInvalid = _this$props.isInvalid,
        error = _this$props.error,
        label = _this$props.label,
        labelType = _this$props.labelType,
        labelAppend = _this$props.labelAppend,
        hasEmptyLabelSpace = _this$props.hasEmptyLabelSpace,
        _this$props$fullWidth = _this$props.fullWidth,
        fullWidth = _this$props$fullWidth === void 0 ? defaultFullWidth : _this$props$fullWidth,
        className = _this$props.className,
        describedByIds = _this$props.describedByIds,
        display = _this$props.display,
        hasChildLabel = _this$props.hasChildLabel,
        propsId = _this$props.id,
        isDisabled = _this$props.isDisabled,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var id = this.state.id;
      var hasLabel = label || labelAppend;
      var classes = (0, _classnames.default)('euiFormRow', {
        'euiFormRow--hasEmptyLabelSpace': hasEmptyLabelSpace,
        'euiFormRow--fullWidth': fullWidth,
        'euiFormRow--hasLabel': hasLabel
      }, displayToClassNameMap[display],
      // Safe use of ! as default prop is 'row'
      className);
      var optionalHelpTexts;
      if (helpText) {
        var helpTexts = Array.isArray(helpText) ? helpText : [helpText];
        optionalHelpTexts = helpTexts.map(function (helpText, i) {
          var key = typeof helpText === 'string' ? helpText : i;
          return (0, _react2.jsx)(_form_help_text.EuiFormHelpText, {
            key: key,
            id: "".concat(id, "-help-").concat(i),
            className: "euiFormRow__text"
          }, helpText);
        });
      }
      var optionalErrors;
      if (error && isInvalid) {
        var errorTexts = Array.isArray(error) ? error : [error];
        optionalErrors = errorTexts.map(function (error, i) {
          var key = typeof error === 'string' ? error : i;
          return (0, _react2.jsx)(_form_error_text.EuiFormErrorText, {
            key: key,
            id: "".concat(id, "-error-").concat(i),
            className: "euiFormRow__text"
          }, error);
        });
      }
      var optionalLabel;
      var isLegend = label && labelType === 'legend' ? true : false;
      var labelId = "".concat(id, "-label");
      if (hasLabel) {
        var labelProps = {};
        if (isLegend) {
          labelProps = {
            type: labelType
          };
        } else {
          labelProps = _objectSpread(_objectSpread({
            htmlFor: hasChildLabel ? id : undefined
          }, !isDisabled && {
            isFocused: this.state.isFocused
          }), {}, {
            // If the row is disabled, don't pass the isFocused state.
            type: labelType
          });
        }
        optionalLabel = (0, _react2.jsx)("div", {
          className: "euiFormRow__labelWrapper"
        }, (0, _react2.jsx)(_form_label.EuiFormLabel, _extends({
          className: "euiFormRow__label",
          isInvalid: isInvalid,
          isDisabled: isDisabled,
          "aria-invalid": isInvalid,
          id: labelId
        }, labelProps), label), labelAppend && ' ', labelAppend);
      }
      var optionalProps = {};
      /**
       * Safe use of ! as default prop is []
       */
      var describingIds = _toConsumableArray(describedByIds);
      if (optionalHelpTexts) {
        optionalHelpTexts.forEach(function (optionalHelpText) {
          return describingIds.push(optionalHelpText.props.id);
        });
      }
      if (optionalErrors) {
        optionalErrors.forEach(function (error) {
          return describingIds.push(error.props.id);
        });
      }
      if (describingIds.length > 0) {
        optionalProps['aria-describedby'] = describingIds.join(' ');
      }
      var child = _react.Children.only(children);
      var field = /*#__PURE__*/(0, _react.cloneElement)(child, _objectSpread({
        id: id,
        // Allow the child's disabled or isDisabled prop to supercede the `isDisabled`
        disabled: (_ref3 = (_child$props$disabled = child.props.disabled) !== null && _child$props$disabled !== void 0 ? _child$props$disabled : child.props.isDisabled) !== null && _ref3 !== void 0 ? _ref3 : isDisabled,
        onFocus: this.onFocus,
        onBlur: this.onBlur
      }, optionalProps));
      var fieldWrapperClasses = (0, _classnames.default)('euiFormRow__fieldWrapper', {
        euiFormRow__fieldWrapperDisplayOnly:
        /**
         * Safe use of ! as default prop is 'row'
         */
        display.startsWith('center')
      });
      var sharedProps = {
        className: classes,
        id: "".concat(id, "-row")
      };
      var contents = (0, _react2.jsx)(_react.default.Fragment, null, optionalLabel, (0, _react2.jsx)("div", {
        className: fieldWrapperClasses
      }, field, optionalErrors, optionalHelpTexts));
      return labelType === 'legend' ? (0, _react2.jsx)("fieldset", _extends({}, sharedProps, rest), contents) : (0, _react2.jsx)("div", _extends({}, sharedProps, rest), contents);
    }
  }]);
}(_react.Component);
_defineProperty(EuiFormRow, "contextType", _eui_form_context.FormContext);
_defineProperty(EuiFormRow, "defaultProps", {
  display: 'row',
  hasEmptyLabelSpace: false,
  describedByIds: [],
  labelType: 'label',
  hasChildLabel: true
});
EuiFormRow.propTypes = {
  /**
     * Defaults to rendering a `<label>` but if passed `'legend'` for labelType,
     * will render both a `<legend>` and the surrounding container as a `<fieldset>`
     */
  labelType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["label"]), _propTypes.default.oneOf(["legend"])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * When `rowCompressed`, just tightens up the spacing;
     * Set to `columnCompressed` if compressed
     * and horizontal layout is needed.
     * Set to `center` or `centerCompressed` to align non-input
     * content better with inline rows.
     * Set to `columnCompressedSwitch` if the form control being passed
     * as the child is a switch.
     */
  /**
     * When `rowCompressed`, just tightens up the spacing;
     * Set to `columnCompressed` if compressed
     * and horizontal layout is needed.
     * Set to `center` or `centerCompressed` to align non-input
     * content better with inline rows.
     * Set to `columnCompressedSwitch` if the form control being passed
     * as the child is a switch.
     */
  display: _propTypes.default.oneOf(["row", "rowCompressed", "columnCompressed", "center", "centerCompressed", "columnCompressedSwitch"]),
  hasEmptyLabelSpace: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  describedByIds: _propTypes.default.arrayOf(_propTypes.default.string.isRequired),
  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  hasChildLabel: _propTypes.default.bool,
  /**
     * ReactElement to render as this component's content
     */
  /**
     * ReactElement to render as this component's content
     */
  children: _propTypes.default.element.isRequired,
  label: _propTypes.default.node,
  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  labelAppend: _propTypes.default.any,
  id: _propTypes.default.string,
  isInvalid: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
     *  Adds a single node/string or an array of nodes/strings below the input
     */
  /**
     *  Adds a single node/string or an array of nodes/strings below the input
     */
  helpText: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
     */
  /**
     *  Passed along to the label element; and to the child field element when `disabled` doesn't already exist on the child field element.
     */
  isDisabled: _propTypes.default.bool
};