"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormControlLayoutDelimited = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../../i18n");
var _icon = require("../../icon");
var _text = require("../../text");
var _form_control_layout = require("./form_control_layout");
var _react2 = require("@emotion/react");
var _excluded = ["startControl", "endControl", "delimiter", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiFormControlLayoutDelimited = exports.EuiFormControlLayoutDelimited = function EuiFormControlLayoutDelimited(_ref) {
  var startControl = _ref.startControl,
    endControl = _ref.endControl,
    delimiter = _ref.delimiter,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isInvalid = rest.isInvalid,
    isDisabled = rest.isDisabled,
    readOnly = rest.readOnly;
  var showInvalidState = isInvalid && !isDisabled && !readOnly;
  var classes = (0, _classnames.default)('euiFormControlLayoutDelimited', className, {
    'euiFormControlLayoutDelimited--isInvalid': showInvalidState
  });
  return (0, _react2.jsx)(_form_control_layout.EuiFormControlLayout, _extends({
    className: classes,
    iconsPosition: "static"
  }, rest), addClassesToControl(startControl), (0, _react2.jsx)(EuiFormControlDelimiter, {
    delimiter: delimiter,
    isInvalid: showInvalidState
  }), addClassesToControl(endControl));
};
EuiFormControlLayoutDelimited.propTypes = {
  /**
       * Left side control
       */
  startControl: _propTypes.default.element.isRequired,
  /**
       * Right side control
       */
  endControl: _propTypes.default.element.isRequired,
  /**
       * The center content. Accepts a string to be wrapped in a subdued EuiText
       * or a single ReactElement
       */
  delimiter: _propTypes.default.node,
  className: _propTypes.default.string
};
var addClassesToControl = function addClassesToControl(control) {
  return /*#__PURE__*/(0, _react.cloneElement)(control, {
    className: (0, _classnames.default)(control.props.className, 'euiFormControlLayoutDelimited__input')
  });
};
var EuiFormControlDelimiter = function EuiFormControlDelimiter(_ref2) {
  var delimiter = _ref2.delimiter,
    isInvalid = _ref2.isInvalid;
  var defaultAriaLabel = (0, _i18n.useEuiI18n)('euiFormControlLayoutDelimited.delimiterLabel', 'to');
  return (0, _react2.jsx)(_text.EuiText, {
    className: "euiFormControlLayoutDelimited__delimiter",
    size: "s",
    color: isInvalid ? 'danger' : 'subdued'
  }, delimiter !== null && delimiter !== void 0 ? delimiter : (0, _react2.jsx)(_icon.EuiIcon, {
    type: "sortRight",
    "aria-label": defaultAriaLabel
  }));
};