"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRightSideIcon = exports.getIconAffordanceStyles = exports.getFormControlClassNameForIconCount = void 0;
var _form_control_layout_icons = require("./form_control_layout_icons");
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The `getFormControlClassNameForIconCount` function helps setup the className appendum
 * depending on the form control's current settings/state.
 *
 * @param icon {boolean} Does it contain a static icon like arrowDown
 * @param clear {boolean} Is it currently clearable
 * @param isLoading {boolean} Is is currently loading
 * @param isInvalid {boolean} It is currently invalid
 * @param isDropdown {boolean} It is as dropdown
 * @returns {string | undefined} Returns the string to append to the base className of the form control; or `undefined` if all evaluate to false
 */

var getFormControlClassNameForIconCount = exports.getFormControlClassNameForIconCount = function getFormControlClassNameForIconCount(_ref) {
  var icon = _ref.icon,
    clear = _ref.clear,
    isLoading = _ref.isLoading,
    isInvalid = _ref.isInvalid,
    isDropdown = _ref.isDropdown;
  var numIcons = [icon, clear, isInvalid, isLoading, isDropdown].filter(function (item) {
    return item === true;
  }).length;

  // This className is also specifically used in `src/global_styling/mixins/_form.scss`
  return numIcons > 0 ? "euiFormControlLayout--".concat(numIcons, "icons") : undefined;
};
var isRightSideIcon = exports.isRightSideIcon = function isRightSideIcon(icon) {
  return !!icon && (0, _form_control_layout_icons.isIconShape)(icon) && icon.side === 'right';
};
var getIconAffordanceStyles = exports.getIconAffordanceStyles = function getIconAffordanceStyles(_ref2) {
  var icon = _ref2.icon,
    clear = _ref2.clear,
    isLoading = _ref2.isLoading,
    isInvalid = _ref2.isInvalid,
    isDropdown = _ref2.isDropdown;
  var cssVariables = {
    '--euiFormControlLeftIconsCount': 0,
    '--euiFormControlRightIconsCount': 0
  };
  if (icon) {
    if (isRightSideIcon(icon)) {
      cssVariables['--euiFormControlRightIconsCount']++;
    } else {
      cssVariables['--euiFormControlLeftIconsCount']++;
    }
  }
  if (clear) cssVariables['--euiFormControlRightIconsCount']++;
  if (isLoading) cssVariables['--euiFormControlRightIconsCount']++;
  if (isInvalid) cssVariables['--euiFormControlRightIconsCount']++;
  if (isDropdown) cssVariables['--euiFormControlRightIconsCount']++;
  var filtered = Object.entries(cssVariables).filter(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
      count = _ref4[1];
    return count > 0;
  });
  return filtered.length ? Object.fromEntries(filtered) : undefined;
};