"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _call_out = require("../call_out");
var _i18n = require("../i18n");
var _eui_form_context = require("./eui_form_context");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "isInvalid", "error", "component", "invalidCallout", "fullWidth"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiForm = exports.EuiForm = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$invalidCallout = _ref.invalidCallout,
    invalidCallout = _ref$invalidCallout === void 0 ? 'above' : _ref$invalidCallout,
    fullWidth = _ref.fullWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var formContext = _react.default.useMemo(function () {
    return {
      defaultFullWidth: fullWidth !== null && fullWidth !== void 0 ? fullWidth : false
    };
  }, [fullWidth]);
  var handleFocus = (0, _react.useCallback)(function (node) {
    node === null || node === void 0 || node.focus();
  }, []);
  var classes = (0, _classnames.default)('euiForm', className);
  var optionalErrors = null;
  if (error) {
    var errorTexts = Array.isArray(error) ? error : [error];
    optionalErrors = (0, _react2.jsx)("ul", null, errorTexts.map(function (error, index) {
      return (0, _react2.jsx)("li", {
        className: "euiForm__error",
        key: index
      }, error);
    }));
  }
  var optionalErrorAlert;
  if (isInvalid && invalidCallout === 'above') {
    optionalErrorAlert = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiForm.addressFormErrors",
      default: "Please address the highlighted errors."
    }, function (addressFormErrors) {
      return (0, _react2.jsx)(_call_out.EuiCallOut, {
        tabIndex: -1,
        ref: handleFocus,
        className: "euiForm__errors",
        title: addressFormErrors,
        color: "danger",
        role: "alert",
        "aria-live": "assertive"
      }, optionalErrors);
    });
  }
  var Element = component;
  return (0, _react2.jsx)(Element
  // @ts-expect-error Element is a <div> or <form>, but TypeScript wants to support both
  , _extends({
    ref: ref,
    className: classes
  }, rest), (0, _react2.jsx)(_eui_form_context.FormContext.Provider, {
    value: formContext
  }, optionalErrorAlert, children));
});
EuiForm.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Which HTML element to render `div` or `form`
       */
  component: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["form"]).isRequired, _propTypes.default.oneOf(["div"])]), _propTypes.default.oneOf(["form", "div"])]),
  isInvalid: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
       * Where to display the callout with the list of errors
       */
  invalidCallout: _propTypes.default.oneOf(["above", "none"]),
  /**
       * When set to `true`, all the rows/controls in this form will
       * default to taking up 100% of the width of their continer. You
       * can specify `fullWidth={false}` on individual rows/controls to
       * disable this behavior for specific components.
       * @default false
       */
  fullWidth: _propTypes.default.bool
};
EuiForm.displayName = 'EuiForm';