"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFieldNumberStyles = void 0;
var _react = require("@emotion/react");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFieldNumberStyles = exports.euiFieldNumberStyles = function euiFieldNumberStyles(euiThemeContext) {
  var formStyles = (0, _form.euiFormControlStyles)(euiThemeContext);
  return {
    euiFieldNumber: /*#__PURE__*/(0, _react.css)(formStyles.shared, "&:is(:invalid, [aria-invalid=\"true\"]){", formStyles.invalid, ";}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";}&[readOnly]{", formStyles.readOnly, ";}&:autofill{", formStyles.autoFill, ";};label:euiFieldNumber;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: formStyles.uncompressed,
    compressed: /*#__PURE__*/(0, _react.css)(formStyles.compressed, ";label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/(0, _react.css)(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/(0, _react.css)(formStyles.inGroup, ";label:inGroup;"),
    controlOnly: /*#__PURE__*/(0, _react.css)(".euiFormControlLayout--group &{", formStyles.inGroup, ";};label:controlOnly;")
  };
};