"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutResizable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _resizable_container = require("../resizable_container");
var _helpers = require("../resizable_container/helpers");
var _flyout = require("./flyout");
var _flyout_resizable = require("./flyout_resizable.styles");
var _react2 = require("@emotion/react");
var _excluded = ["size", "maxWidth", "minWidth", "onResize", "side", "type", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
// If not omitted, the correct props don't show up in the docs prop table

var EuiFlyoutResizable = exports.EuiFlyoutResizable = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var size = _ref.size,
    maxWidth = _ref.maxWidth,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 200 : _ref$minWidth,
    onResize = _ref.onResize,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'overlay' : _ref$type,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_resizable.euiFlyoutResizableButtonStyles);
  var cssStyles = [styles.euiFlyoutResizableButton, styles[type][side]];
  var getFlyoutMinMaxWidth = (0, _react.useCallback)(function (width) {
    return Math.min(Math.max(width, minWidth), maxWidth || Infinity, window.innerWidth - 20 // Leave some offset
    );
  }, [minWidth, maxWidth]);
  var _useState = (0, _react.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    flyoutWidth = _useState2[0],
    setFlyoutWidth = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    callOnResize = _useState4[0],
    setCallOnResize = _useState4[1];

  // Must use state for the flyout ref in order for the useEffect to be correctly called after render
  var _useState5 = (0, _react.useState)(null),
    _useState6 = _slicedToArray(_useState5, 2),
    flyoutRef = _useState6[0],
    setFlyoutRef = _useState6[1];
  var setRefs = (0, _services.useCombinedRefs)([setFlyoutRef, ref]);
  (0, _react.useEffect)(function () {
    if (!flyoutWidth && flyoutRef) {
      setCallOnResize(false); // Don't call `onResize` for non-user width changes
      setFlyoutWidth(getFlyoutMinMaxWidth(flyoutRef.offsetWidth));
    }
  }, [flyoutWidth, flyoutRef, getFlyoutMinMaxWidth]);

  // Update flyout width when consumers pass in a new `size`
  (0, _react.useEffect)(function () {
    setCallOnResize(false);
    // For string `size`s, resetting flyoutWidth to 0 will trigger the above useEffect's recalculation
    setFlyoutWidth(typeof size === 'number' ? getFlyoutMinMaxWidth(size) : 0);
  }, [size, getFlyoutMinMaxWidth]);

  // Initial numbers to calculate from, on resize drag start
  var initialWidth = (0, _react.useRef)(0);
  var initialMouseX = (0, _react.useRef)(0);

  // Account for flyout side and logical property direction
  var direction = (0, _react.useMemo)(function () {
    var modifier = side === 'right' ? -1 : 1;
    if (flyoutRef) {
      var languageDirection = window.getComputedStyle(flyoutRef).direction;
      if (languageDirection === 'rtl') modifier *= -1;
    }
    return modifier;
  }, [side, flyoutRef]);
  var onMouseMove = (0, _react.useCallback)(function (e) {
    var mouseOffset = (0, _helpers.getPosition)(e, true) - initialMouseX.current;
    var changedFlyoutWidth = initialWidth.current + mouseOffset * direction;
    setFlyoutWidth(getFlyoutMinMaxWidth(changedFlyoutWidth));
  }, [getFlyoutMinMaxWidth, direction]);
  var onMouseUp = (0, _react.useCallback)(function () {
    setCallOnResize(true);
    initialMouseX.current = 0;
    window.removeEventListener('mousemove', onMouseMove);
    window.removeEventListener('mouseup', onMouseUp);
    window.removeEventListener('touchmove', onMouseMove);
    window.removeEventListener('touchend', onMouseUp);
  }, [onMouseMove]);
  var onMouseDown = (0, _react.useCallback)(function (e) {
    var _flyoutRef$offsetWidt;
    setCallOnResize(false);
    initialMouseX.current = (0, _helpers.getPosition)(e, true);
    initialWidth.current = (_flyoutRef$offsetWidt = flyoutRef === null || flyoutRef === void 0 ? void 0 : flyoutRef.offsetWidth) !== null && _flyoutRef$offsetWidt !== void 0 ? _flyoutRef$offsetWidt : 0;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [flyoutRef, onMouseMove, onMouseUp]);
  var onKeyDown = (0, _react.useCallback)(function (e) {
    setCallOnResize(true);
    var KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case _services.keys.ARROW_RIGHT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth + KEYBOARD_OFFSET * direction);
        });
        break;
      case _services.keys.ARROW_LEFT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth - KEYBOARD_OFFSET * direction);
        });
    }
  }, [getFlyoutMinMaxWidth, direction]);

  // To reduce unnecessary calls, only fire onResize callback:
  // 1. After initial mount / on user width change events only
  // 2. If not currently mouse dragging
  (0, _react.useEffect)(function () {
    if (callOnResize) {
      onResize === null || onResize === void 0 || onResize(flyoutWidth);
    }
  }, [onResize, callOnResize, flyoutWidth]);
  return (0, _react2.jsx)(_flyout.EuiFlyout, _extends({}, rest, {
    size: flyoutWidth || size,
    maxWidth: maxWidth,
    side: side,
    type: type,
    ref: setRefs
  }), (0, _react2.jsx)(_resizable_container.EuiResizableButton, {
    isHorizontal: true,
    indicator: "border",
    css: cssStyles,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onKeyDown: onKeyDown
  }), children);
});
EuiFlyoutResizable.displayName = 'EuiFlyoutResizable';