"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFilterSelectItemStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFilterSelectItemStyles = exports.euiFilterSelectItemStyles = function euiFilterSelectItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var focusStyles = "\n    color: ".concat(euiTheme.colors.primary, ";\n    background-color: ").concat(euiTheme.focus.backgroundColor, ";\n    outline-offset: -").concat(euiTheme.focus.width, ";\n    text-decoration: underline;\n\n    &:disabled {\n      background-color: ").concat((0, _services.transparentize)(euiTheme.colors.disabled, 0.1), ";\n    }\n  ");
  return {
    euiFilterSelectItem: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalShorthandCSS)('padding', "".concat(euiTheme.size.xs, " ").concat(euiTheme.size.m)), " ", (0, _global_styling.euiFontSize)(euiThemeContext, 's'), " ", (0, _global_styling.logicalTextAlignCSS)('left'), " color:", euiTheme.colors.text, ";", (0, _global_styling.logicalCSS)('border-bottom', "".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.lightestShade)), " &:hover{cursor:pointer;text-decoration:underline;}&:focus{", focusStyles, ";}&:disabled{cursor:not-allowed;text-decoration:none;color:", euiTheme.colors.disabledText, ";};label:euiFilterSelectItem;"),
    isFocused: /*#__PURE__*/(0, _react.css)(focusStyles, ";;label:isFocused;")
  };
};