"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFilterButtonStyles = exports.euiFilterButtonDisplay = exports.euiFilterButtonChildStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiFilterButtonDisplay = exports.euiFilterButtonDisplay = function euiFilterButtonDisplay(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    flex: '1 1 auto',
    minInlineSize: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 3;
    })
  };
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "jkp921-noGrow",
  styles: "flex-grow:0;label:noGrow;"
} : {
  name: "jkp921-noGrow",
  styles: "flex-grow:0;label:noGrow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilterButtonStyles = exports.euiFilterButtonStyles = function euiFilterButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    controlHeight = _euiFormVariables.controlHeight,
    borderColor = _euiFormVariables.borderColor;

  // Box shadow simulates borders without affecting width
  var leftBoxShadow = "-".concat(euiTheme.border.width.thin, " 0 0 0 ").concat(borderColor);
  // Bottom borders are needed for responsive flex-wrap behavior
  var bottomBoxShadow = "0 ".concat(euiTheme.border.width.thin, " 0 0 ").concat(borderColor);
  return {
    euiFilterButton: /*#__PURE__*/(0, _react.css)(euiFilterButtonDisplay(euiThemeContext), " ", (0, _global_styling.logicalCSS)('height', controlHeight), " border-radius:0;box-shadow:", leftBoxShadow, ",", bottomBoxShadow, ";&:hover:not(:disabled),&:focus:not(:disabled){text-decoration:none;.euiFilterButton__text{text-decoration:underline;}}&:focus-visible{outline-offset:-", euiTheme.focus.width, ";};label:euiFilterButton;"),
    withNext: /*#__PURE__*/(0, _react.css)("&+.euiFilterButton{", (0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.size.xs)), "box-shadow:", bottomBoxShadow, ";};label:withNext;"),
    noGrow: _ref3,
    hasNotification: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 6;
    })), ";;label:hasNotification;"),
    hasActiveFilters: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.bold, ";;label:hasActiveFilters;")
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1w3amc7-disabled",
  styles: "opacity:0.5;label:disabled;"
} : {
  name: "1w3amc7-disabled",
  styles: "opacity:0.5;label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "nd1u8j-euiFilterButton__notification",
  styles: "cursor:inherit;label:euiFilterButton__notification;"
} : {
  name: "nd1u8j-euiFilterButton__notification",
  styles: "cursor:inherit;label:euiFilterButton__notification;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilterButtonChildStyles = exports.euiFilterButtonChildStyles = function euiFilterButtonChildStyles(_ref5) {
  var euiTheme = _ref5.euiTheme;
  return {
    content: {
      euiFilterButton__content: /*#__PURE__*/(0, _react.css)(";label:euiFilterButton__content;"),
      hasIcon: /*#__PURE__*/(0, _react.css)("&>.euiIcon:last-child{", (0, _global_styling.logicalCSS)('margin-left', 'auto'), ";};label:hasIcon;")
    },
    text: {
      euiFilterButton__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextShift)('bold', 'data-text', euiTheme), " ", (0, _global_styling.euiTextTruncate)(), ";;label:euiFilterButton__text;"),
      hasNotification: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x * 3;
      })), ";;label:hasNotification;")
    },
    notification: {
      euiFilterButton__notification: _ref2,
      disabled: _ref
    }
  };
};