"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _super_date_picker = require("./super_date_picker");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />
var SuperDatePicker = function SuperDatePicker() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = (0, _react.useState)(true),
    _useState4 = _slicedToArray(_useState3, 1),
    showUpdateButton = _useState4[0];
  var _useState5 = (0, _react.useState)('now-30m'),
    _useState6 = _slicedToArray(_useState5, 2),
    start = _useState6[0],
    setStart = _useState6[1];
  var _useState7 = (0, _react.useState)('now'),
    _useState8 = _slicedToArray(_useState7, 2),
    end = _useState8[0],
    setEnd = _useState8[1];
  var _useState9 = (0, _react.useState)(true),
    _useState10 = _slicedToArray(_useState9, 1),
    showFill = _useState10[0];
  var onTimeChange = function onTimeChange(_ref) {
    var start = _ref.start,
      end = _ref.end;
    setStart(start);
    setEnd(end);
    setIsLoading(true);
    startLoading();
  };
  var startLoading = function startLoading() {
    setTimeout(stopLoading, 1000);
  };
  var stopLoading = function stopLoading() {
    setIsLoading(false);
  };
  var datepickerProps = {
    isLoading: isLoading,
    start: start,
    end: end,
    onTimeChange: onTimeChange,
    showUpdateButton: showUpdateButton
  };
  return (0, _react2.jsx)(_super_date_picker.EuiSuperDatePicker, _extends({}, datepickerProps, {
    updateButtonProps: {
      fill: showFill
    }
  }));
};
beforeEach(function () {
  cy.mount((0, _react2.jsx)(SuperDatePicker, null));
  cy.get('div.euiSuperDatePicker').should('exist');
});
describe('EuiSuperDatePicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when quick select menu is open', function () {
      cy.get('button.euiFormControlLayout__prepend').click();
      cy.get('div.euiPanel').contains('Quick select').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when start / end date menus are open', function () {
      cy.get('button.euiSuperDatePicker__prettyFormat').click();
      cy.get('div.euiDatePopoverContent').should('exist');
      cy.checkAxe();
      cy.get('button.euiDatePopoverButton--start').click();
      cy.get('button.euiDatePopoverButton--end').click();
      cy.get('div.euiDatePopoverContent').should('exist');
      cy.checkAxe();
      cy.get('button.euiDatePopoverButton--end').click();
      cy.get('div.euiDatePopoverContent').should('not.exist');
      cy.checkAxe();
    });
  });
});