"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiQuickSelectPopover = exports.EuiQuickSelectPanels = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _button = require("../../../button");
var _icon = require("../../../icon");
var _popover = require("../../../popover");
var _title = require("../../../title");
var _text = require("../../../text");
var _i18n = require("../../../i18n");
var _quick_select = require("./quick_select");
var _commonly_used_time_ranges = require("./commonly_used_time_ranges");
var _recently_used = require("./recently_used");
var _refresh_interval = require("../../auto_refresh/refresh_interval");
var _react2 = require("@emotion/react");
var _excluded = ["applyTime"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiQuickSelectPopover = exports.EuiQuickSelectPopover = function EuiQuickSelectPopover(_ref) {
  var _applyTime = _ref.applyTime,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useState = (0, _react.useState)(),
    _useState2 = _slicedToArray(_useState, 2),
    prevQuickSelect = _useState2[0],
    setQuickSelect = _useState2[1];
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isOpen = _useState4[0],
    setIsOpen = _useState4[1];
  var closePopover = (0, _react.useCallback)(function () {
    return setIsOpen(false);
  }, []);
  var togglePopover = (0, _react.useCallback)(function () {
    return setIsOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var applyTime = (0, _react.useCallback)(function (_ref2) {
    var start = _ref2.start,
      end = _ref2.end,
      quickSelect = _ref2.quickSelect,
      _ref2$keepPopoverOpen = _ref2.keepPopoverOpen,
      keepPopoverOpen = _ref2$keepPopoverOpen === void 0 ? false : _ref2$keepPopoverOpen;
    _applyTime({
      start: start,
      end: end
    });
    if (quickSelect) {
      setQuickSelect(quickSelect);
    }
    if (!keepPopoverOpen) {
      closePopover();
    }
  }, [_applyTime, closePopover]);
  var buttonlabel = (0, _i18n.useEuiI18n)('euiQuickSelectPopover.buttonLabel', 'Date quick select');
  var quickSelectButton = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    className: "euiFormControlLayout__prepend",
    contentProps: {
      className: 'euiQuickSelectPopover__buttonContent'
    },
    onClick: togglePopover,
    "aria-label": buttonlabel,
    title: buttonlabel,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    isDisabled: props.isDisabled,
    "data-test-subj": "superDatePickerToggleQuickMenuButton"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "calendar"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    button: quickSelectButton,
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "downLeft"
  }, (0, _react2.jsx)(EuiQuickSelectPanels, _extends({}, props, {
    applyTime: applyTime,
    prevQuickSelect: prevQuickSelect
  })));
};
EuiQuickSelectPopover.propTypes = {
  applyRefreshInterval: _propTypes.default.func,
  applyTime: _propTypes.default.func.isRequired,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  customQuickSelectPanels: _propTypes.default.arrayOf(_propTypes.default.shape({
    title: _propTypes.default.string.isRequired,
    content: _propTypes.default.element.isRequired
  }).isRequired),
  customQuickSelectRender: _propTypes.default.func,
  dateFormat: _propTypes.default.string.isRequired,
  end: _propTypes.default.string.isRequired,
  isDisabled: _propTypes.default.bool.isRequired,
  isPaused: _propTypes.default.bool.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  refreshInterval: _propTypes.default.number.isRequired,
  intervalUnits: _propTypes.default.any,
  start: _propTypes.default.string.isRequired,
  timeOptions: _propTypes.default.shape({
    timeTenseOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    timeUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    relativeOptions: _propTypes.default.arrayOf(_propTypes.default.shape({
      text: _propTypes.default.string.isRequired,
      value: _propTypes.default.oneOfType([_propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired, _propTypes.default.oneOf(["s+", "m+", "h+", "d+", "w+", "M+", "y+"]).isRequired]).isRequired
    }).isRequired).isRequired,
    relativeRoundingLabels: _propTypes.default.any.isRequired,
    refreshUnitsOptions: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
    commonDurationRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
      end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
      label: _propTypes.default.string,
      start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
    }).isRequired).isRequired
  }).isRequired
};
var EuiQuickSelectPanels = exports.EuiQuickSelectPanels = function EuiQuickSelectPanels(_ref3) {
  var start = _ref3.start,
    end = _ref3.end,
    dateFormat = _ref3.dateFormat,
    timeOptions = _ref3.timeOptions,
    commonlyUsedRanges = _ref3.commonlyUsedRanges,
    recentlyUsedRanges = _ref3.recentlyUsedRanges,
    customQuickSelectPanels = _ref3.customQuickSelectPanels,
    customQuickSelectRender = _ref3.customQuickSelectRender,
    isPaused = _ref3.isPaused,
    refreshInterval = _ref3.refreshInterval,
    intervalUnits = _ref3.intervalUnits,
    applyRefreshInterval = _ref3.applyRefreshInterval,
    applyTime = _ref3.applyTime,
    prevQuickSelect = _ref3.prevQuickSelect;
  var quickSelectElement = (0, _react2.jsx)(_quick_select.EuiQuickSelect, {
    applyTime: applyTime,
    start: start,
    end: end,
    prevQuickSelect: prevQuickSelect,
    timeOptions: timeOptions
  });
  var commonlyUsedElement = (0, _react2.jsx)(_commonly_used_time_ranges.EuiCommonlyUsedTimeRanges, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges
  });
  var recentlyUsedElement = (0, _react2.jsx)(_recently_used.EuiRecentlyUsed, {
    applyTime: applyTime,
    commonlyUsedRanges: commonlyUsedRanges,
    dateFormat: dateFormat,
    recentlyUsedRanges: recentlyUsedRanges
  });
  var refreshIntervalElement = applyRefreshInterval && (0, _react2.jsx)(_refresh_interval.EuiRefreshInterval, {
    onRefreshChange: applyRefreshInterval,
    isPaused: isPaused,
    refreshInterval: refreshInterval,
    intervalUnits: intervalUnits
  });
  var customQuickSelectPanelsElement = (0, _react.useMemo)(function () {
    if (!customQuickSelectPanels) {
      return null;
    }
    return customQuickSelectPanels.map(function (_ref4) {
      var title = _ref4.title,
        content = _ref4.content;
      return (0, _react2.jsx)("div", {
        key: title,
        className: "euiQuickSelectPopover__panel"
      }, (0, _react2.jsx)(_title.EuiTitle, {
        size: "xxxs"
      }, (0, _react2.jsx)("span", null, title)), (0, _react2.jsx)(_text.EuiText, {
        size: "s",
        className: "euiQuickSelectPopover__section"
      }, /*#__PURE__*/_react.default.cloneElement(content, {
        applyTime: applyTime
      })));
    });
  }, [customQuickSelectPanels, applyTime]);
  return (0, _react2.jsx)("div", {
    className: "euiQuickSelectPopover__content",
    "data-test-subj": "superDatePickerQuickMenu"
  }, customQuickSelectRender ? customQuickSelectRender({
    quickSelect: quickSelectElement,
    commonlyUsedRanges: commonlyUsedElement,
    recentlyUsedRanges: recentlyUsedElement,
    refreshInterval: refreshIntervalElement,
    customQuickSelectPanels: customQuickSelectPanelsElement
  }) : (0, _react2.jsx)(_react.default.Fragment, null, quickSelectElement, commonlyUsedElement, recentlyUsedElement, refreshIntervalElement, customQuickSelectPanelsElement));
};
EuiQuickSelectPanels.propTypes = {
  prevQuickSelect: _propTypes.default.shape({
    timeTense: _propTypes.default.string.isRequired,
    timeValue: _propTypes.default.number.isRequired,
    timeUnits: _propTypes.default.oneOf(["s", "m", "h", "d", "w", "M", "y"]).isRequired
  })
};