"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAbsoluteTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _moment = _interopRequireDefault(require("moment"));
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _form = require("../../../form");
var _flex = require("../../../flex");
var _button = require("../../../button");
var _code = require("../../../code");
var _i18n = require("../../../i18n");
var _date_picker = require("../../date_picker");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // eslint-disable-line import/named
// Allow users to paste in and have the datepicker parse multiple common date formats,
// in addition to the configured displayed `dateFormat` prop
var ALLOWED_USER_DATE_FORMATS = [_moment.default.ISO_8601, _moment.default.RFC_2822, 'X' // Unix timestamp in seconds
];
var EuiAbsoluteTab = exports.EuiAbsoluteTab = /*#__PURE__*/function (_Component) {
  // Store outside of state as a ref for faster/unbatched updates

  function EuiAbsoluteTab(props) {
    var _this;
    _classCallCheck(this, EuiAbsoluteTab);
    _this = _callSuper(this, EuiAbsoluteTab, [props]);
    _defineProperty(_this, "state", void 0);
    _defineProperty(_this, "isParsing", false);
    _defineProperty(_this, "handleChange", function (date) {
      var onChange = _this.props.onChange;
      if (date === null) {
        return;
      }
      onChange(date.toISOString());
      var valueAsMoment = (0, _moment.default)(date);
      _this.setState({
        valueAsMoment: valueAsMoment,
        textInputValue: valueAsMoment.format(_this.props.dateFormat),
        hasUnparsedText: false,
        isTextInvalid: false
      });
    });
    _defineProperty(_this, "handleTextChange", function (event) {
      if (_this.isParsing) return;
      _this.setState({
        textInputValue: event.target.value,
        hasUnparsedText: true,
        isTextInvalid: false
      });
    });
    _defineProperty(_this, "parseUserDateInput", function (textInputValue) {
      _this.isParsing = true;
      // Wait a tick for state to finish updating (whatever gets returned),
      // and then allow `onChange` user input to continue setting state
      requestAnimationFrame(function () {
        _this.isParsing = false;
      });
      var invalidDateState = {
        textInputValue: textInputValue,
        isTextInvalid: true,
        valueAsMoment: null
      };
      if (!textInputValue) {
        return _this.setState(invalidDateState);
      }
      var _this$props = _this.props,
        onChange = _this$props.onChange,
        dateFormat = _this$props.dateFormat,
        locale = _this$props.locale;

      // Attempt to parse with passed `dateFormat` and `locale`
      var valueAsMoment = (0, _moment.default)(textInputValue, dateFormat, typeof locale === 'string' ? locale : 'en',
      // Narrow the union type to string
      true);
      var dateIsValid = valueAsMoment.isValid();

      // If not valid, try a few other other standardized formats
      if (!dateIsValid) {
        valueAsMoment = (0, _moment.default)(textInputValue, ALLOWED_USER_DATE_FORMATS, true);
        dateIsValid = valueAsMoment.isValid();
      }
      if (dateIsValid) {
        onChange(valueAsMoment.toISOString());
        _this.setState({
          textInputValue: valueAsMoment.format(_this.props.dateFormat),
          valueAsMoment: valueAsMoment,
          hasUnparsedText: false,
          isTextInvalid: false
        });
      } else {
        _this.setState(invalidDateState);
      }
    });
    var parsedValue = _datemath.default.parse(props.value, {
      roundUp: props.roundUp
    });
    var _valueAsMoment = parsedValue && parsedValue.isValid() ? parsedValue : (0, _moment.default)();
    var _textInputValue = _valueAsMoment.locale(_this.props.locale || 'en').format(_this.props.dateFormat);
    _this.state = {
      hasUnparsedText: false,
      isTextInvalid: false,
      textInputValue: _textInputValue,
      valueAsMoment: _valueAsMoment
    };
    return _this;
  }
  _inherits(EuiAbsoluteTab, _Component);
  return _createClass(EuiAbsoluteTab, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        dateFormat = _this$props2.dateFormat,
        timeFormat = _this$props2.timeFormat,
        locale = _this$props2.locale,
        utcOffset = _this$props2.utcOffset,
        labelPrefix = _this$props2.labelPrefix;
      var _this$state = this.state,
        valueAsMoment = _this$state.valueAsMoment,
        isTextInvalid = _this$state.isTextInvalid,
        hasUnparsedText = _this$state.hasUnparsedText,
        textInputValue = _this$state.textInputValue;
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_date_picker.EuiDatePicker, {
        inline: true,
        showTimeSelect: true,
        shadow: false,
        selected: valueAsMoment,
        onChange: this.handleChange,
        dateFormat: dateFormat,
        timeFormat: timeFormat,
        locale: locale,
        utcOffset: utcOffset
      }), (0, _react2.jsx)(_i18n.EuiI18n, {
        tokens: ['euiAbsoluteTab.dateFormatButtonLabel', 'euiAbsoluteTab.dateFormatError'],
        defaults: ['Parse date', 'Allowed formats: {dateFormat}, ISO 8601, RFC 2822, or Unix timestamp.'],
        values: {
          dateFormat: (0, _react2.jsx)(_code.EuiCode, null, dateFormat)
        }
      }, function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          dateFormatButtonLabel = _ref2[0],
          dateFormatError = _ref2[1];
        return (0, _react2.jsx)(_flex.EuiFlexGroup, {
          component: "form",
          onSubmit: function onSubmit(e) {
            e.preventDefault(); // Prevents a page refresh/reload
            _this2.parseUserDateInput(textInputValue);
          },
          className: "euiSuperDatePicker__absoluteDateForm",
          gutterSize: "s",
          responsive: false
        }, (0, _react2.jsx)(_form.EuiFormRow, {
          className: "euiSuperDatePicker__absoluteDateFormRow",
          isInvalid: isTextInvalid,
          error: isTextInvalid ? dateFormatError : undefined,
          helpText: hasUnparsedText && !isTextInvalid ? dateFormatError : undefined
        }, (0, _react2.jsx)(_form.EuiFieldText, {
          compressed: true,
          isInvalid: isTextInvalid,
          value: textInputValue,
          onChange: _this2.handleTextChange,
          onPaste: function onPaste(event) {
            _this2.parseUserDateInput(event.clipboardData.getData('text'));
          },
          "data-test-subj": "superDatePickerAbsoluteDateInput",
          prepend: (0, _react2.jsx)(_form.EuiFormLabel, null, labelPrefix)
        })), hasUnparsedText && (0, _react2.jsx)(_button.EuiButtonIcon, {
          type: "submit",
          className: "euiSuperDatePicker__absoluteDateFormSubmit",
          size: "s",
          display: "base",
          iconType: "check",
          "aria-label": dateFormatButtonLabel,
          title: dateFormatButtonLabel,
          "data-test-subj": "parseAbsoluteDateFormat"
        }));
      }));
    }
  }]);
}(_react.Component);
EuiAbsoluteTab.propTypes = {
  dateFormat: _propTypes.default.string.isRequired,
  timeFormat: _propTypes.default.string.isRequired,
  locale: _propTypes.default.any,
  value: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  roundUp: _propTypes.default.bool.isRequired,
  position: _propTypes.default.oneOf(["start", "end"]).isRequired,
  labelPrefix: _propTypes.default.string.isRequired,
  utcOffset: _propTypes.default.number
};