"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _date_utils = require("./date_utils");
var _accessibility = require("../../../accessibility");
var _html_id_generator = require("../../../../services/accessibility/html_id_generator");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2018 HackerOne Inc and individual contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
function doHoursAndMinutesAlign(time1, time2) {
  if (time1 == null || time2 == null) return false;
  return (0, _date_utils.getHour)(time1) === (0, _date_utils.getHour)(time2) && (0, _date_utils.getMinute)(time1) === (0, _date_utils.getMinute)(time2);
}
var Time = exports.default = /*#__PURE__*/function (_React$Component) {
  function Time() {
    var _this;
    _classCallCheck(this, Time);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, Time, [].concat(args));
    _defineProperty(_this, "onFocus", function () {
      if (_this.props.accessibleMode) {
        _this.setState({
          readInstructions: true,
          isFocused: true
        });
      }
    });
    _defineProperty(_this, "onBlur", function () {
      if (_this.props.accessibleMode) {
        _this.setState({
          readInstructions: false,
          isFocused: false
        });
      }
    });
    _defineProperty(_this, "onInputKeyDown", function (event) {
      var eventKey = event.key;
      var copy = (0, _date_utils.newDate)(_this.state.preSelection);
      var newSelection;
      switch (eventKey) {
        case "ArrowUp":
          newSelection = (0, _date_utils.addMinutes)(copy, -_this.props.intervals);
          break;
        case "ArrowDown":
          newSelection = (0, _date_utils.addMinutes)(copy, _this.props.intervals);
          break;
        case " ":
        case "Enter":
          event.preventDefault();
          _this.handleClick(_this.state.preSelection);
          break;
      }
      if (!newSelection) return; // Let the input component handle this keydown
      event.preventDefault();
      _this.setState({
        preSelection: newSelection,
        needsScrollToPreSelection: true
      });
    });
    _defineProperty(_this, "handleClick", function (time) {
      if ((_this.props.minTime || _this.props.maxTime) && (0, _date_utils.isTimeInDisabledRange)(time, _this.props) || _this.props.excludeTimes && (0, _date_utils.isTimeDisabled)(time, _this.props.excludeTimes) || _this.props.includeTimes && !(0, _date_utils.isTimeDisabled)(time, _this.props.includeTimes)) {
        return;
      }
      _this.props.onChange(time);
    });
    _defineProperty(_this, "liClasses", function (time, activeTime) {
      var classes = ["react-datepicker__time-list-item"];
      if (doHoursAndMinutesAlign(time, activeTime)) {
        classes.push("react-datepicker__time-list-item--selected");
      } else if (_this.state.preSelection && doHoursAndMinutesAlign(time, _this.state.preSelection)) {
        classes.push("react-datepicker__time-list-item--preselected");
      }
      if ((_this.props.minTime || _this.props.maxTime) && (0, _date_utils.isTimeInDisabledRange)(time, _this.props) || _this.props.excludeTimes && (0, _date_utils.isTimeDisabled)(time, _this.props.excludeTimes) || _this.props.includeTimes && !(0, _date_utils.isTimeDisabled)(time, _this.props.includeTimes)) {
        classes.push("react-datepicker__time-list-item--disabled");
      }
      if (_this.props.injectTimes && ((0, _date_utils.getHour)(time) * 60 + (0, _date_utils.getMinute)(time)) % _this.props.intervals !== 0) {
        classes.push("react-datepicker__time-list-item--injected");
      }
      return classes.join(" ");
    });
    _defineProperty(_this, "generateTimes", function () {
      var times = [];
      var intervals = _this.props.intervals;
      var base = (0, _date_utils.getStartOfDay)((0, _date_utils.newDate)());
      var multiplier = 1440 / intervals;
      var sortedInjectTimes = _this.props.injectTimes && _this.props.injectTimes.sort(function (a, b) {
        return a - b;
      });
      for (var i = 0; i < multiplier; i++) {
        var currentTime = (0, _date_utils.addMinutes)((0, _date_utils.cloneDate)(base), i * intervals);
        times.push(currentTime);
        if (sortedInjectTimes) {
          var timesToInject = (0, _date_utils.timesToInjectAfter)(base, currentTime, i, intervals, sortedInjectTimes);
          times = times.concat(timesToInject);
        }
      }
      return times;
    });
    _defineProperty(_this, "renderTimes", function () {
      var times = _this.generateTimes();
      var activeTime = _this.props.selected ? _this.props.selected : (0, _date_utils.newDate)();
      var format = _this.props.format ? _this.props.format : _this.timeFormat;
      var currH = (0, _date_utils.getHour)(activeTime);
      var currM = (0, _date_utils.getMinute)(activeTime);
      return times.map(function (time, i) {
        return (0, _react2.jsx)("li", {
          key: i,
          onClick: _this.handleClick.bind(_this, time),
          className: _this.liClasses(time, activeTime),
          ref: function ref(li) {
            if (li && li.classList.contains("react-datepicker__time-list-item--preselected")) {
              _this.preselectedLi = li;
            }
            if (li && li.classList.contains("react-datepicker__time-list-item--selected")) {
              _this.selectedLi = li;
            }
          },
          role: "option",
          id: _this.timeOptionId("datepicker_time_".concat(i))
        }, (0, _date_utils.formatDate)(time, format));
      });
    });
    var _times = _this.generateTimes();
    var preSelection = _times.reduce(function (preSelection, time) {
      if (preSelection) return preSelection;
      if (doHoursAndMinutesAlign(time, _this.props.selected)) {
        return time;
      }
    }, null);
    if (preSelection == null) {
      // there is no exact pre-selection, find the element closest to the selected time and preselect it
      var currH = _this.props.selected ? (0, _date_utils.getHour)(_this.props.selected) : (0, _date_utils.getHour)((0, _date_utils.newDate)());
      var currM = _this.props.selected ? (0, _date_utils.getMinute)(_this.props.selected) : (0, _date_utils.getMinute)((0, _date_utils.newDate)());
      var closestTimeIndex = Math.floor((60 * currH + currM) / _this.props.intervals);
      var closestMinutes = closestTimeIndex * _this.props.intervals;
      preSelection = (0, _date_utils.setTime)((0, _date_utils.newDate)(), {
        hour: Math.floor(closestMinutes / 60),
        minute: closestMinutes % 60,
        second: 0,
        millisecond: 0
      });
    }
    _this.timeOptionId = (0, _html_id_generator.htmlIdGenerator)();
    _this.timeFormat = "hh:mm A";
    _this.state = {
      preSelection: preSelection,
      needsScrollToPreSelection: false,
      readInstructions: false,
      isFocused: false
    };
    return _this;
  }
  _inherits(Time, _React$Component);
  return _createClass(Time, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      // code to ensure selected time will always be in focus within time window when it first appears
      var scrollParent = this.list;
      scrollParent.scrollTop = Time.calcCenterPosition(this.props.monthRef ? this.props.monthRef.clientHeight - this.header.clientHeight : this.list.clientHeight, this.selectedLi || this.preselectedLi);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      // if selection changed, scroll to the selected item
      if (this.props.selected && this.props.selected.isSame(prevProps.selected) === false) {
        var scrollToElement = this.selectedLi;
        if (scrollToElement) {
          // an element matches the selected time, scroll to it
          scrollToElement.scrollIntoView({
            behavior: "instant",
            block: "nearest",
            inline: "nearest"
          });
        }

        // update preSelection to the selection
        this.setState(function (prevState) {
          return {
            preSelection: prevState.selected
          };
        });
      }
      if (this.state.needsScrollToPreSelection) {
        var _scrollToElement = this.preselectedLi;
        if (_scrollToElement) {
          // an element matches the selected time, scroll to it
          _scrollToElement.scrollIntoView({
            behavior: "instant",
            block: "nearest",
            inline: "nearest"
          });
        }
        this.setState({
          needsScrollToPreSelection: false
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var height = null;
      if (this.props.monthRef && this.header) {
        height = this.props.monthRef.clientHeight - this.header.clientHeight;
      }
      var classNames = (0, _classnames.default)("react-datepicker__time-container", {
        "react-datepicker__time-container--with-today-button": this.props.todayButton,
        "react-datepicker__time-container--focus": this.state.isFocused
      });
      var timeBoxClassNames = (0, _classnames.default)("react-datepicker__time-box", {
        "react-datepicker__time-box--accessible": this.props.accessibleMode
      });
      var screenReaderInstructions;
      if (this.state.readInstructions) {
        screenReaderInstructions = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("p", null, "You are a in a time selector. Use the up and down keys to select from other common times then press enter to confirm."), (0, _react2.jsx)("p", null, this.state.preSelection ? "".concat((0, _date_utils.formatDate)(this.state.preSelection, this.timeFormat), " is currently\n            focused.") : "No time is currently focused."));
      }
      return (0, _react2.jsx)("div", {
        className: classNames
      }, (0, _react2.jsx)("div", {
        className: "react-datepicker__header react-datepicker__header--time",
        ref: function ref(header) {
          _this2.header = header;
        }
      }, (0, _react2.jsx)("div", {
        className: "react-datepicker-time__header"
      }, this.props.timeCaption), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", {
        "aria-live": "polite",
        "aria-atomic": "false"
      }, screenReaderInstructions))), (0, _react2.jsx)("div", {
        className: "react-datepicker__time"
      }, (0, _react2.jsx)("div", {
        className: timeBoxClassNames,
        onKeyDown: this.onInputKeyDown,
        onFocus: this.onFocus,
        onBlur: this.onBlur
      }, (0, _react2.jsx)("ul", {
        "aria-label": this.props.timeCaption,
        className: "react-datepicker__time-list",
        ref: function ref(list) {
          _this2.list = list;
        },
        style: height ? {
          height: height
        } : {},
        role: "listbox",
        tabIndex: this.props.accessibleMode ? 0 : -1
      }, this.renderTimes.bind(this)()))));
    }
  }], [{
    key: "defaultProps",
    get: function get() {
      return {
        intervals: 30,
        onTimeChange: function onTimeChange() {},
        todayButton: null,
        timeCaption: "Time"
      };
    }
  }]);
}(_react.default.Component);
_defineProperty(Time, "propTypes", {
  format: _propTypes.default.string,
  includeTimes: _propTypes.default.array,
  intervals: _propTypes.default.number,
  selected: _propTypes.default.object,
  onChange: _propTypes.default.func,
  todayButton: _propTypes.default.node,
  minTime: _propTypes.default.object,
  maxTime: _propTypes.default.object,
  excludeTimes: _propTypes.default.array,
  monthRef: _propTypes.default.object,
  timeCaption: _propTypes.default.string,
  injectTimes: _propTypes.default.array,
  accessibleMode: _propTypes.default.bool
});
_defineProperty(Time, "calcCenterPosition", function (listHeight, centerLiRef) {
  return centerLiRef.offsetTop - (listHeight / 2 - centerLiRef.clientHeight / 2);
});
module.exports = exports.default;