"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _year_dropdown = _interopRequireDefault(require("./year_dropdown"));
var _month_dropdown = _interopRequireDefault(require("./month_dropdown"));
var _month_year_dropdown = _interopRequireDefault(require("./month_year_dropdown"));
var _month = _interopRequireDefault(require("./month"));
var _time = _interopRequireDefault(require("./time"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _calendar_container = _interopRequireDefault(require("./calendar_container"));
var _focus_trap = require("../../../focus_trap");
var _screen_reader_only = require("../../../accessibility/screen_reader_only");
var _date_utils = require("./date_utils");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); } /*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2018 HackerOne Inc and individual contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
var FocusTrapContainer = /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
  return (0, _react2.jsx)("div", _extends({
    ref: ref,
    className: "react-datepicker__focusTrap"
  }, props));
});
var DROPDOWN_FOCUS_CLASSNAMES = ["react-datepicker__year-select", "react-datepicker__month-select", "react-datepicker__month-year-select"];
var isDropdownSelect = function isDropdownSelect() {
  var element = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var classNames = (element.className || "").split(/\s+/);
  return DROPDOWN_FOCUS_CLASSNAMES.some(function (testClassname) {
    return classNames.indexOf(testClassname) >= 0;
  });
};
var Calendar = exports.default = /*#__PURE__*/function (_React$Component) {
  function Calendar(props) {
    var _this;
    _classCallCheck(this, Calendar);
    _this = _callSuper(this, Calendar, [props]);
    _defineProperty(_this, "setMonthRef", function (node) {
      _this.monthRef = node;
    });
    _defineProperty(_this, "setYearRef", function (node) {
      _this.yearRef = node;
    });
    _defineProperty(_this, "handleOnDropdownToggle", function (isOpen, dropdown) {
      _this.setState({
        pauseFocusTrap: isOpen
      });
      if (!isOpen) {
        var element = dropdown === 'month' ? _this.monthRef : _this.yearRef;
        if (element) {
          // The focus trap has been unpaused and will reinitialize focus
          // but does so on the wrong element (calendar)
          // This refocuses the previous element (dropdown button).
          // Duration arrived at by trial-and-error.
          setTimeout(function () {
            return element.focus();
          }, 25);
        }
      }
    });
    _defineProperty(_this, "handleClickOutside", function (event) {
      _this.props.onClickOutside(event);
    });
    _defineProperty(_this, "handleDropdownFocus", function (event) {
      if (isDropdownSelect(event.target)) {
        _this.props.onDropdownFocus();
      }
    });
    _defineProperty(_this, "getDateInView", function () {
      var _this$props = _this.props,
        preSelection = _this$props.preSelection,
        selected = _this$props.selected,
        openToDate = _this$props.openToDate,
        utcOffset = _this$props.utcOffset;
      var minDate = (0, _date_utils.getEffectiveMinDate)(_this.props);
      var maxDate = (0, _date_utils.getEffectiveMaxDate)(_this.props);
      var current = (0, _date_utils.now)(utcOffset);
      var initialDate = openToDate || selected || preSelection;
      if (initialDate) {
        return initialDate;
      } else {
        if (minDate && (0, _date_utils.isBefore)(current, minDate)) {
          return minDate;
        } else if (maxDate && (0, _date_utils.isAfter)(current, maxDate)) {
          return maxDate;
        }
      }
      return current;
    });
    _defineProperty(_this, "localizeDate", function (date) {
      return (0, _date_utils.localizeDate)(date, _this.props.locale);
    });
    _defineProperty(_this, "increaseMonth", function () {
      _this.setState({
        date: (0, _date_utils.addMonths)((0, _date_utils.cloneDate)(_this.state.date), 1)
      }, function () {
        return _this.handleMonthChange(_this.state.date);
      });
    });
    _defineProperty(_this, "decreaseMonth", function () {
      _this.setState({
        date: (0, _date_utils.subtractMonths)((0, _date_utils.cloneDate)(_this.state.date), 1)
      }, function () {
        return _this.handleMonthChange(_this.state.date);
      });
    });
    _defineProperty(_this, "handleDayClick", function (day, event) {
      return _this.props.onSelect(day, event);
    });
    _defineProperty(_this, "handleDayMouseEnter", function (day) {
      return _this.setState({
        selectingDate: day
      });
    });
    _defineProperty(_this, "handleMonthMouseLeave", function () {
      return _this.setState({
        selectingDate: null
      });
    });
    _defineProperty(_this, "handleYearChange", function (date) {
      if (_this.props.onYearChange) {
        _this.props.onYearChange(date);
      }
      if (_this.props.accessibleMode) {
        _this.handleSelectionChange(date);
      }
    });
    _defineProperty(_this, "handleMonthChange", function (date) {
      if (_this.props.onMonthChange) {
        _this.props.onMonthChange(date);
      }
      if (_this.props.accessibleMode) {
        _this.handleSelectionChange(date);
      }
    });
    _defineProperty(_this, "handleSelectionChange", function (date) {
      if (_this.props.adjustDateOnChange) {
        _this.props.updateSelection(date);
      } else {
        _this.props.updateSelection((0, _date_utils.getStartOfMonth)((0, _date_utils.cloneDate)(date)));
      }
    });
    _defineProperty(_this, "handleMonthYearChange", function (date) {
      _this.handleYearChange(date);
      _this.handleMonthChange(date);
    });
    _defineProperty(_this, "changeYear", function (year) {
      _this.setState({
        date: (0, _date_utils.setYear)((0, _date_utils.cloneDate)(_this.state.date), year)
      }, function () {
        return _this.handleYearChange(_this.state.date);
      });
    });
    _defineProperty(_this, "changeMonth", function (month) {
      _this.setState({
        date: (0, _date_utils.setMonth)((0, _date_utils.cloneDate)(_this.state.date), month)
      }, function () {
        return _this.handleMonthChange(_this.state.date);
      });
    });
    _defineProperty(_this, "changeMonthYear", function (monthYear) {
      _this.setState({
        date: (0, _date_utils.setYear)((0, _date_utils.setMonth)((0, _date_utils.cloneDate)(_this.state.date), (0, _date_utils.getMonth)(monthYear)), (0, _date_utils.getYear)(monthYear))
      }, function () {
        return _this.handleMonthYearChange(_this.state.date);
      });
    });
    _defineProperty(_this, "header", function () {
      var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this.state.date;
      var startOfWeek = (0, _date_utils.getStartOfWeek)((0, _date_utils.cloneDate)(date));
      var dayNames = [];
      if (_this.props.showWeekNumbers) {
        dayNames.push((0, _react2.jsx)("div", {
          key: "W",
          className: "react-datepicker__day-name"
        }, _this.props.weekLabel || "#"));
      }
      return dayNames.concat([0, 1, 2, 3, 4, 5, 6].map(function (offset) {
        var day = (0, _date_utils.addDays)((0, _date_utils.cloneDate)(startOfWeek), offset);
        var localeData = (0, _date_utils.getLocaleData)(day);
        var weekDayName = _this.formatWeekday(localeData, day);
        var weekDayNameLong = localeData.weekdays(day);
        return (0, _react2.jsx)("div", {
          key: offset,
          className: "react-datepicker__day-name"
        }, (0, _react2.jsx)("span", {
          "aria-hidden": "true"
        }, weekDayName), (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, weekDayNameLong)));
      }));
    });
    _defineProperty(_this, "formatWeekday", function (localeData, day) {
      if (_this.props.formatWeekDay) {
        return (0, _date_utils.getFormattedWeekdayInLocale)(localeData, day, _this.props.formatWeekDay);
      }
      return _this.props.useWeekdaysShort ? (0, _date_utils.getWeekdayShortInLocale)(localeData, day) : (0, _date_utils.getWeekdayMinInLocale)(localeData, day);
    });
    _defineProperty(_this, "renderPreviousMonthButton", function () {
      if (_this.props.renderCustomHeader) {
        return;
      }
      var allPrevDaysDisabled = (0, _date_utils.allDaysDisabledBefore)(_this.state.date, "month", _this.props);
      if (!_this.props.forceShowMonthNavigation && !_this.props.showDisabledMonthNavigation && allPrevDaysDisabled || _this.props.showTimeSelectOnly) {
        return;
      }
      var classes = ["react-datepicker__navigation", "react-datepicker__navigation--previous"];
      var clickHandler = _this.decreaseMonth;
      if (allPrevDaysDisabled && _this.props.showDisabledMonthNavigation) {
        classes.push("react-datepicker__navigation--previous--disabled");
        clickHandler = null;
      }
      return (0, _react2.jsx)("button", {
        type: "button",
        className: classes.join(" "),
        onClick: clickHandler,
        disabled: !_this.props.accessibleMode
      }, _this.props.previousMonthButtonLabel);
    });
    _defineProperty(_this, "renderNextMonthButton", function () {
      if (_this.props.renderCustomHeader) {
        return;
      }
      var allNextDaysDisabled = (0, _date_utils.allDaysDisabledAfter)(_this.state.date, "month", _this.props);
      if (!_this.props.forceShowMonthNavigation && !_this.props.showDisabledMonthNavigation && allNextDaysDisabled || _this.props.showTimeSelectOnly) {
        return;
      }
      var classes = ["react-datepicker__navigation", "react-datepicker__navigation--next"];
      if (_this.props.showTimeSelect) {
        classes.push("react-datepicker__navigation--next--with-time");
      }
      if (_this.props.todayButton) {
        classes.push("react-datepicker__navigation--next--with-today-button");
      }
      var clickHandler = _this.increaseMonth;
      if (allNextDaysDisabled && _this.props.showDisabledMonthNavigation) {
        classes.push("react-datepicker__navigation--next--disabled");
        clickHandler = null;
      }
      return (0, _react2.jsx)("button", {
        type: "button",
        className: classes.join(" "),
        onClick: clickHandler,
        disabled: !_this.props.accessibleMode
      }, _this.props.nextMonthButtonLabel);
    });
    _defineProperty(_this, "renderCurrentMonth", function () {
      var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _this.state.date;
      var classes = ["react-datepicker__current-month"];
      if (_this.props.showYearDropdown) {
        classes.push("react-datepicker__current-month--hasYearDropdown");
      }
      if (_this.props.showMonthDropdown) {
        classes.push("react-datepicker__current-month--hasMonthDropdown");
      }
      if (_this.props.showMonthYearDropdown) {
        classes.push("react-datepicker__current-month--hasMonthYearDropdown");
      }
      return (0, _react2.jsx)("div", {
        className: classes.join(" ")
      }, (0, _date_utils.formatDate)(date, _this.props.dateFormat));
    });
    _defineProperty(_this, "renderYearDropdown", function () {
      var overrideHide = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      if (!_this.props.showYearDropdown || overrideHide) {
        return;
      }
      return (0, _react2.jsx)(_year_dropdown.default, {
        adjustDateOnChange: _this.props.adjustDateOnChange,
        date: _this.state.date,
        onSelect: _this.props.onSelect,
        setOpen: _this.props.setOpen,
        dropdownMode: _this.props.dropdownMode,
        onChange: _this.changeYear,
        minDate: _this.props.minDate,
        maxDate: _this.props.maxDate,
        year: (0, _date_utils.getYear)(_this.state.date),
        scrollableYearDropdown: _this.props.scrollableYearDropdown,
        yearDropdownItemNumber: _this.props.yearDropdownItemNumber,
        accessibleMode: _this.props.accessibleMode,
        onDropdownToggle: _this.handleOnDropdownToggle,
        buttonRef: _this.setYearRef
      });
    });
    _defineProperty(_this, "renderMonthDropdown", function () {
      var overrideHide = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      if (!_this.props.showMonthDropdown || overrideHide) {
        return;
      }
      return (0, _react2.jsx)(_month_dropdown.default, {
        dropdownMode: _this.props.dropdownMode,
        locale: _this.props.locale,
        dateFormat: _this.props.dateFormat,
        onChange: _this.changeMonth,
        month: (0, _date_utils.getMonth)(_this.state.date),
        useShortMonthInDropdown: _this.props.useShortMonthInDropdown,
        accessibleMode: _this.props.accessibleMode,
        onDropdownToggle: _this.handleOnDropdownToggle,
        buttonRef: _this.setMonthRef
      });
    });
    _defineProperty(_this, "renderMonthYearDropdown", function () {
      var overrideHide = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      if (!_this.props.showMonthYearDropdown || overrideHide) {
        return;
      }
      return (0, _react2.jsx)(_month_year_dropdown.default, {
        dropdownMode: _this.props.dropdownMode,
        locale: _this.props.locale,
        dateFormat: _this.props.dateFormat,
        onChange: _this.changeMonthYear,
        minDate: _this.props.minDate,
        maxDate: _this.props.maxDate,
        date: _this.state.date,
        scrollableMonthYearDropdown: _this.props.scrollableMonthYearDropdown,
        accessibleMode: _this.props.accessibleMode
      });
    });
    _defineProperty(_this, "renderTodayButton", function () {
      if (!_this.props.todayButton || _this.props.showTimeSelectOnly) {
        return;
      }
      return (0, _react2.jsx)("div", {
        className: "react-datepicker__today-button",
        onClick: function onClick(e) {
          return _this.props.onSelect((0, _date_utils.getStartOfDate)((0, _date_utils.now)(_this.props.utcOffset)), e);
        }
      }, _this.props.todayButton);
    });
    _defineProperty(_this, "renderDefaultHeader", function (_ref) {
      var monthDate = _ref.monthDate,
        i = _ref.i;
      return (0, _react2.jsx)("div", {
        className: "react-datepicker__header"
      }, _this.renderCurrentMonth(monthDate), (0, _react2.jsx)("div", {
        className: "react-datepicker__header__dropdown react-datepicker__header__dropdown--".concat(_this.props.dropdownMode),
        onFocus: _this.handleDropdownFocus
      }, _this.renderMonthDropdown(i !== 0), _this.renderMonthYearDropdown(i !== 0), _this.renderYearDropdown(i !== 0)), (0, _react2.jsx)("div", {
        className: "react-datepicker__day-names"
      }, _this.header(monthDate)));
    });
    _defineProperty(_this, "renderCustomHeader", function (_ref2) {
      var monthDate = _ref2.monthDate,
        i = _ref2.i;
      if (i !== 0) {
        return null;
      }
      var prevMonthButtonDisabled = (0, _date_utils.allDaysDisabledBefore)(_this.state.date, "month", _this.props);
      var nextMonthButtonDisabled = (0, _date_utils.allDaysDisabledAfter)(_this.state.date, "month", _this.props);
      return (0, _react2.jsx)("div", {
        className: "react-datepicker__header react-datepicker__header--custom",
        onFocus: _this.props.onDropdownFocus
      }, _this.props.renderCustomHeader(_objectSpread(_objectSpread({}, _this.state), {}, {
        changeMonth: _this.changeMonth,
        changeYear: _this.changeYear,
        decreaseMonth: _this.decreaseMonth,
        increaseMonth: _this.increaseMonth,
        prevMonthButtonDisabled: prevMonthButtonDisabled,
        nextMonthButtonDisabled: nextMonthButtonDisabled
      })), (0, _react2.jsx)("div", {
        className: "react-datepicker__day-names"
      }, _this.header(monthDate)));
    });
    _defineProperty(_this, "renderMonths", function () {
      if (_this.props.showTimeSelectOnly) {
        return;
      }
      var monthList = [];
      for (var i = 0; i < _this.props.monthsShown; ++i) {
        var monthDate = (0, _date_utils.addMonths)((0, _date_utils.cloneDate)(_this.state.date), i);
        var monthKey = "month-".concat(i);
        monthList.push((0, _react2.jsx)("div", {
          key: monthKey,
          ref: function ref(div) {
            _this.monthContainer = div;
          },
          className: "react-datepicker__month-container"
        }, _this.props.renderCustomHeader ? _this.renderCustomHeader({
          monthDate: monthDate,
          i: i
        }) : _this.renderDefaultHeader({
          monthDate: monthDate,
          i: i
        }), (0, _react2.jsx)(_month.default, {
          day: monthDate,
          dayClassName: _this.props.dayClassName,
          onDayClick: _this.handleDayClick,
          onDayMouseEnter: _this.handleDayMouseEnter,
          onMouseLeave: _this.handleMonthMouseLeave,
          onWeekSelect: _this.props.onWeekSelect,
          formatWeekNumber: _this.props.formatWeekNumber,
          minDate: _this.props.minDate,
          maxDate: _this.props.maxDate,
          excludeDates: _this.props.excludeDates,
          highlightDates: _this.props.highlightDates,
          selectingDate: _this.state.selectingDate,
          includeDates: _this.props.includeDates,
          inline: _this.props.inline,
          fixedHeight: _this.props.fixedHeight,
          filterDate: _this.props.filterDate,
          preSelection: _this.props.preSelection,
          selected: _this.props.selected,
          selectsStart: _this.props.selectsStart,
          selectsEnd: _this.props.selectsEnd,
          showWeekNumbers: _this.props.showWeekNumbers,
          startDate: _this.props.startDate,
          endDate: _this.props.endDate,
          peekNextMonth: _this.props.peekNextMonth,
          utcOffset: _this.props.utcOffset,
          setOpen: _this.props.setOpen,
          shouldCloseOnSelect: _this.props.shouldCloseOnSelect,
          renderDayContents: _this.props.renderDayContents,
          disabledKeyboardNavigation: _this.props.disabledKeyboardNavigation,
          updateSelection: _this.props.updateSelection,
          accessibleMode: _this.props.accessibleMode
        })));
      }
      return monthList;
    });
    _defineProperty(_this, "renderTimeSection", function () {
      if (_this.props.showTimeSelect && (_this.state.monthContainer || _this.props.showTimeSelectOnly)) {
        return (0, _react2.jsx)(_time.default, {
          selected: _this.props.selected,
          onChange: _this.props.onTimeChange,
          format: _this.props.timeFormat,
          includeTimes: _this.props.includeTimes,
          intervals: _this.props.timeIntervals,
          minTime: _this.props.minTime,
          maxTime: _this.props.maxTime,
          excludeTimes: _this.props.excludeTimes,
          timeCaption: _this.props.timeCaption,
          todayButton: _this.props.todayButton,
          showMonthDropdown: _this.props.showMonthDropdown,
          showMonthYearDropdown: _this.props.showMonthYearDropdown,
          showYearDropdown: _this.props.showYearDropdown,
          withPortal: _this.props.withPortal,
          monthRef: _this.state.monthContainer,
          injectTimes: _this.props.injectTimes,
          accessibleMode: _this.props.accessibleMode
        });
      }
    });
    _this.state = {
      date: _this.localizeDate(_this.getDateInView()),
      selectingDate: null,
      monthContainer: null,
      pauseFocusTrap: false
    };
    _this.monthRef = /*#__PURE__*/_react.default.createRef();
    _this.yearRef = /*#__PURE__*/_react.default.createRef();
    return _this;
  }
  _inherits(Calendar, _React$Component);
  return _createClass(Calendar, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      // monthContainer height is needed in time component
      // to determine the height for the ul in the time component
      // setState here so height is given after final component
      // layout is rendered
      if (this.props.showTimeSelect) {
        this.assignMonthContainer = function () {
          _this2.setState({
            monthContainer: _this2.monthContainer
          });
        }();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.preSelection && !(0, _date_utils.isSameDay)(this.props.preSelection, prevProps.preSelection)) {
        this.setState({
          date: this.localizeDate(this.props.preSelection)
        });
      } else if (this.props.openToDate && !(0, _date_utils.isSameDay)(this.props.openToDate, prevProps.openToDate)) {
        this.setState({
          date: this.localizeDate(this.props.openToDate)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var Container = this.props.container || _calendar_container.default;
      var classes = (0, _classnames.default)("react-datepicker", this.props.className, {
        "react-datepicker--time-only": this.props.showTimeSelectOnly,
        "react-datepicker--non-interactive": !this.props.isCalendarInteractive
      });
      var trapFocus = this.props.accessibleMode && !this.props.inline;
      var initialFocusTarget = this.props.showTimeSelectOnly ? ".react-datepicker__time-box--accessible" : ".react-datepicker__month--accessible";
      if (trapFocus) {
        return (0, _react2.jsx)(Container, {
          className: classes
        }, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
          disabled: this.state.pauseFocusTrap || !this.props.enableFocusTrap,
          className: "react-datepicker__focusTrap",
          initialFocus: initialFocusTarget,
          onClickOutside: this.handleClickOutside
        }, this.renderPreviousMonthButton(), this.renderNextMonthButton(), this.renderMonths(), this.renderTodayButton(), this.renderTimeSection(), this.props.children));
      } else {
        return (0, _react2.jsx)(Container, {
          className: classes
        }, this.renderPreviousMonthButton(), this.renderNextMonthButton(), this.renderMonths(), this.renderTodayButton(), this.renderTimeSection(), this.props.children);
      }
    }
  }], [{
    key: "defaultProps",
    get: function get() {
      return {
        onDropdownFocus: function onDropdownFocus() {},
        monthsShown: 1,
        forceShowMonthNavigation: false,
        timeCaption: "Time",
        previousMonthButtonLabel: "Previous Month",
        nextMonthButtonLabel: "Next Month",
        enableFocusTrap: true
      };
    }
  }]);
}(_react.default.Component);
_defineProperty(Calendar, "propTypes", {
  adjustDateOnChange: _propTypes.default.bool,
  className: _propTypes.default.string,
  children: _propTypes.default.node,
  container: _propTypes.default.func,
  dateFormat: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.array]).isRequired,
  dayClassName: _propTypes.default.func,
  disabledKeyboardNavigation: _propTypes.default.bool,
  dropdownMode: _propTypes.default.oneOf(["scroll", "select"]),
  endDate: _propTypes.default.object,
  excludeDates: _propTypes.default.array,
  filterDate: _propTypes.default.func,
  fixedHeight: _propTypes.default.bool,
  formatWeekNumber: _propTypes.default.func,
  highlightDates: _propTypes.default.instanceOf(Map),
  includeDates: _propTypes.default.array,
  includeTimes: _propTypes.default.array,
  injectTimes: _propTypes.default.array,
  inline: _propTypes.default.bool,
  locale: _propTypes.default.string,
  maxDate: _propTypes.default.object,
  minDate: _propTypes.default.object,
  monthsShown: _propTypes.default.number,
  onClickOutside: _propTypes.default.func.isRequired,
  onMonthChange: _propTypes.default.func,
  onYearChange: _propTypes.default.func,
  forceShowMonthNavigation: _propTypes.default.bool,
  onDropdownFocus: _propTypes.default.func,
  onSelect: _propTypes.default.func.isRequired,
  onWeekSelect: _propTypes.default.func,
  showTimeSelect: _propTypes.default.bool,
  showTimeSelectOnly: _propTypes.default.bool,
  timeFormat: _propTypes.default.string,
  timeIntervals: _propTypes.default.number,
  onTimeChange: _propTypes.default.func,
  minTime: _propTypes.default.object,
  maxTime: _propTypes.default.object,
  excludeTimes: _propTypes.default.array,
  timeCaption: _propTypes.default.string,
  openToDate: _propTypes.default.object,
  peekNextMonth: _propTypes.default.bool,
  scrollableYearDropdown: _propTypes.default.bool,
  scrollableMonthYearDropdown: _propTypes.default.bool,
  preSelection: _propTypes.default.object,
  selected: _propTypes.default.object,
  selectsEnd: _propTypes.default.bool,
  selectsStart: _propTypes.default.bool,
  showMonthDropdown: _propTypes.default.bool,
  showMonthYearDropdown: _propTypes.default.bool,
  showWeekNumbers: _propTypes.default.bool,
  showYearDropdown: _propTypes.default.bool,
  startDate: _propTypes.default.object,
  todayButton: _propTypes.default.node,
  useWeekdaysShort: _propTypes.default.bool,
  formatWeekDay: _propTypes.default.func,
  withPortal: _propTypes.default.bool,
  utcOffset: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  weekLabel: _propTypes.default.string,
  yearDropdownItemNumber: _propTypes.default.number,
  setOpen: _propTypes.default.func,
  shouldCloseOnSelect: _propTypes.default.bool,
  useShortMonthInDropdown: _propTypes.default.bool,
  showDisabledMonthNavigation: _propTypes.default.bool,
  previousMonthButtonLabel: _propTypes.default.string,
  nextMonthButtonLabel: _propTypes.default.string,
  renderCustomHeader: _propTypes.default.func,
  renderDayContents: _propTypes.default.func,
  updateSelection: _propTypes.default.func.isRequired,
  accessibleMode: _propTypes.default.bool,
  enableFocusTrap: _propTypes.default.bool
});
module.exports = exports.default;