"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRowHeightUtils = exports.useDefaultRowHeight = exports.cellPaddingsMap = exports.RowHeightVirtualizationUtils = exports.RowHeightUtils = exports.DEFAULT_ROW_HEIGHT = exports.AUTO_HEIGHT = void 0;
var _react = require("react");
var _services = require("../../../services");
var _predicate = require("../../../services/predicate");
var _sorting = require("./sorting");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// TODO: Once JS variables are available, use them here instead of hard-coded maps
var cellPaddingsMap = exports.cellPaddingsMap = {
  s: 4,
  m: 6,
  l: 8
};
var AUTO_HEIGHT = exports.AUTO_HEIGHT = 'auto';
var DEFAULT_ROW_HEIGHT = exports.DEFAULT_ROW_HEIGHT = 34;
var RowHeightUtils = exports.RowHeightUtils = /*#__PURE__*/function () {
  function RowHeightUtils() {
    var _this = this;
    _classCallCheck(this, RowHeightUtils);
    /**
     * Styles utils
     */
    _defineProperty(this, "styles", {
      paddingTop: 0,
      paddingBottom: 0
    });
    /**
     * Height types
     */
    _defineProperty(this, "getHeightType", function (option) {
      if (option == null) {
        return 'default';
      }
      if (option === AUTO_HEIGHT) {
        return 'auto';
      }
      if (_this.getLineCount(option) != null) {
        return 'lineCount';
      }
      return 'numerical';
    });
    /**
     * Heights cache utils
     * This cache is primarily used by auto heights & secondarily used by lineCount row overrides
     */
    _defineProperty(this, "heightsCache", new Map());
  }
  return _createClass(RowHeightUtils, [{
    key: "getRowHeightOption",
    value: function getRowHeightOption(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro, _rowHeightsOptions$ro2;
      return (_rowHeightsOptions$ro = rowHeightsOptions === null || rowHeightsOptions === void 0 || (_rowHeightsOptions$ro2 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro2 === void 0 ? void 0 : _rowHeightsOptions$ro2[rowIndex]) !== null && _rowHeightsOptions$ro !== void 0 ? _rowHeightsOptions$ro : rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight;
    }
  }, {
    key: "isRowHeightOverride",
    value: function isRowHeightOverride(rowIndex, rowHeightsOptions) {
      var _rowHeightsOptions$ro3;
      return (rowHeightsOptions === null || rowHeightsOptions === void 0 || (_rowHeightsOptions$ro3 = rowHeightsOptions.rowHeights) === null || _rowHeightsOptions$ro3 === void 0 ? void 0 : _rowHeightsOptions$ro3[rowIndex]) != null;
    }
  }, {
    key: "getCalculatedHeight",
    value: function getCalculatedHeight(heightOption, defaultHeight, rowIndex, isRowHeightOverride) {
      if ((0, _predicate.isObject)(heightOption) && heightOption.height) {
        return Math.max(heightOption.height, defaultHeight);
      }
      if (heightOption && (0, _predicate.isNumber)(heightOption)) {
        return Math.max(heightOption, defaultHeight);
      }
      if ((0, _predicate.isObject)(heightOption) && heightOption.lineCount) {
        if (isRowHeightOverride) {
          return this.getRowHeight(rowIndex) || defaultHeight; // lineCount overrides are stored in the heights cache
        } else {
          return defaultHeight; // default lineCount height is set in minRowHeight state in grid_row_body
        }
      }
      if (heightOption === AUTO_HEIGHT && rowIndex != null) {
        return this.getRowHeight(rowIndex);
      }
      return defaultHeight;
    }
  }, {
    key: "cacheStyles",
    value: function cacheStyles(gridStyles) {
      this.styles = {
        paddingTop: cellPaddingsMap[gridStyles.cellPadding || 'm'],
        paddingBottom: cellPaddingsMap[gridStyles.cellPadding || 'm']
      };
    }
  }, {
    key: "getLineCount",
    value:
    /**
     * Line count utils
     */

    function getLineCount(option) {
      return (0, _predicate.isObject)(option) ? option.lineCount : undefined;
    }
  }, {
    key: "calculateHeightForLineCount",
    value: function calculateHeightForLineCount(cellRef, lineCount, excludePadding) {
      var computedStyles = window.getComputedStyle(cellRef, null);
      var lineHeight = parseInt(computedStyles.lineHeight, 10);
      var contentHeight = Math.ceil(lineCount * lineHeight);
      return excludePadding ? contentHeight : contentHeight + this.styles.paddingTop + this.styles.paddingBottom;
    }

    /**
     * Auto height utils
     */
  }, {
    key: "isAutoHeight",
    value: function isAutoHeight(rowIndex, rowHeightsOptions) {
      var height = this.getRowHeightOption(rowIndex, rowHeightsOptions);
      if (height === AUTO_HEIGHT) {
        return true;
      }
      return false;
    }
  }, {
    key: "getRowHeight",
    value: function getRowHeight(rowIndex) {
      var rowHeights = this.heightsCache.get(rowIndex);
      if (rowHeights == null) return 0;
      var rowHeightValues = Array.from(rowHeights.values());
      if (!rowHeightValues.length) return 0;
      return Math.max.apply(Math, rowHeightValues);
    }
  }, {
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_ROW_HEIGHT;
      var _visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var rowHeights = this.heightsCache.get(rowIndex) || new Map();
      var adaptedHeight = Math.ceil(height);
      if (rowHeights.get(colId) === adaptedHeight) {
        return false;
      } else {
        rowHeights.set(colId, adaptedHeight);
        this.heightsCache.set(rowIndex, rowHeights);
        return true;
      }
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var visibleColumnIds = new Set(visibleColumns.map(function (_ref) {
        var id = _ref.id;
        return id;
      }));
      var didModify = false;
      this.heightsCache.forEach(function (rowHeights) {
        var existingColumnIds = Array.from(rowHeights.keys());
        existingColumnIds.forEach(function (existingColumnId) {
          if (visibleColumnIds.has(existingColumnId) === false) {
            didModify = true;
            rowHeights.delete(existingColumnId);
          }
        });
      });
      return didModify;
    }
  }]);
}();
/**
 * Row height utils with virtualization library-specific APIs
 */
var RowHeightVirtualizationUtils = exports.RowHeightVirtualizationUtils = /*#__PURE__*/function (_RowHeightUtils2) {
  function RowHeightVirtualizationUtils(gridRef, outerGridElementRef, gridItemsRenderedRef, rerenderGridBodyRef) {
    var _this2;
    _classCallCheck(this, RowHeightVirtualizationUtils);
    _this2 = _callSuper(this, RowHeightVirtualizationUtils);
    /**
     * Virtualization workarounds for auto height rows
     */
    _defineProperty(_this2, "timerId", void 0);
    _defineProperty(_this2, "lastUpdatedRow", Infinity);
    _this2.gridRef = gridRef;
    _this2.outerGridElementRef = outerGridElementRef;
    _this2.gridItemsRenderedRef = gridItemsRenderedRef;
    _this2.rerenderGridBodyRef = rerenderGridBodyRef;
    return _this2;
  }
  _inherits(RowHeightVirtualizationUtils, _RowHeightUtils2);
  return _createClass(RowHeightVirtualizationUtils, [{
    key: "setRowHeight",
    value: function setRowHeight(rowIndex, colId) {
      var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : DEFAULT_ROW_HEIGHT;
      var visibleRowIndex = arguments.length > 3 ? arguments[3] : undefined;
      var didModify = _get(_getPrototypeOf(RowHeightVirtualizationUtils.prototype), "setRowHeight", this).call(this, rowIndex, colId, height, visibleRowIndex);

      // When an auto row height is updated, force a re-render
      // of the grid body to update the unconstrained height
      if (didModify) {
        var _this$rerenderGridBod, _this$rerenderGridBod2;
        (_this$rerenderGridBod = (_this$rerenderGridBod2 = this.rerenderGridBodyRef).current) === null || _this$rerenderGridBod === void 0 || _this$rerenderGridBod.call(_this$rerenderGridBod2);
        this.resetRow(visibleRowIndex);
      }
      return didModify; // Mostly just here for typing
    }
  }, {
    key: "pruneHiddenColumnHeights",
    value: function pruneHiddenColumnHeights(visibleColumns) {
      var didModify = _get(_getPrototypeOf(RowHeightVirtualizationUtils.prototype), "pruneHiddenColumnHeights", this).call(this, visibleColumns);
      if (didModify) {
        this.resetRow(0);
      }
      return didModify; // Mostly just here for typing
    }
  }, {
    key: "resetRow",
    value: function resetRow(visibleRowIndex) {
      var _this3 = this;
      // save the first row index of batch, reassigning it only
      // if this visible row index less than lastUpdatedRow
      this.lastUpdatedRow = Math.min(this.lastUpdatedRow, visibleRowIndex);
      clearTimeout(this.timerId);
      this.timerId = window.setTimeout(function () {
        return _this3.resetGrid();
      }, 0);
    }
  }, {
    key: "resetGrid",
    value: function resetGrid() {
      var _this$gridRef$current;
      (_this$gridRef$current = this.gridRef.current) === null || _this$gridRef$current === void 0 || _this$gridRef$current.resetAfterRowIndex(this.lastUpdatedRow);
      this.lastUpdatedRow = Infinity;
    }
  }, {
    key: "compensateForLayoutShift",
    value: function compensateForLayoutShift(rowIndex, verticalLayoutShift, anchorRow) {
      var grid = this.gridRef.current;
      var outerGridElement = this.outerGridElementRef.current;
      var renderedItems = this.gridItemsRenderedRef.current;
      if (grid == null || outerGridElement == null || renderedItems == null || anchorRow == null || !Number.isFinite(verticalLayoutShift)) {
        return;
      }

      // skip if the start row is the anchor row but it hasn't shifted
      if (anchorRow === 'start' && renderedItems.visibleRowStartIndex !== rowIndex) {
        return;
      }

      // skip if the center row is the anchor row but it hasn't shifted
      if (anchorRow === 'center' && Math.floor((renderedItems.visibleRowStopIndex - renderedItems.visibleRowStartIndex) / 2) !== rowIndex) {
        return;
      }
      grid.scrollTo({
        scrollTop: outerGridElement.scrollTop + verticalLayoutShift
      });
    }
  }]);
}(RowHeightUtils);
/**
 * Hook for instantiating RowHeightUtils, setting internal class vars,
 * and setting up various row-height-related side effects
 */
var useRowHeightUtils = exports.useRowHeightUtils = function useRowHeightUtils(_ref2) {
  var virtualization = _ref2.virtualization,
    rowHeightsOptions = _ref2.rowHeightsOptions,
    gridStyles = _ref2.gridStyles,
    columns = _ref2.columns;
  var forceRenderRef = (0, _services.useLatest)((0, _services.useForceRender)());
  var _useState = (0, _react.useState)(function () {
      if (virtualization) {
        var _gridRef = virtualization.gridRef,
          _outerGridElementRef = virtualization.outerGridElementRef,
          _gridItemsRenderedRef = virtualization.gridItemsRenderedRef;
        return new RowHeightVirtualizationUtils(_gridRef, _outerGridElementRef, _gridItemsRenderedRef, forceRenderRef);
      } else {
        return new RowHeightUtils();
      }
    }),
    _useState2 = _slicedToArray(_useState, 1),
    rowHeightUtils = _useState2[0];

  // Forces a rerender whenever the row heights change, as this can cause the
  // grid to change height/have scrollbars. Without this, grid rerendering is stale
  (0, _react.useEffect)(function () {
    if (forceRenderRef.current == null) {
      return;
    }
    requestAnimationFrame(forceRenderRef.current);
  }, [// Effects that should cause rerendering
  rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.defaultHeight, rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : rowHeightsOptions.rowHeights,
  // Dependencies
  rowHeightUtils, forceRenderRef]);

  // Re-cache styles whenever grid density changes
  (0, _react.useEffect)(function () {
    rowHeightUtils.cacheStyles({
      cellPadding: gridStyles.cellPadding
    });
  }, [gridStyles.cellPadding, rowHeightUtils]);

  // Update row heights map to remove hidden columns whenever orderedVisibleColumns change
  (0, _react.useEffect)(function () {
    rowHeightUtils.pruneHiddenColumnHeights(columns);
  }, [rowHeightUtils, columns]);
  return rowHeightUtils;
};
var useDefaultRowHeight = exports.useDefaultRowHeight = function useDefaultRowHeight(_ref3) {
  var rowHeightsOptions = _ref3.rowHeightsOptions,
    rowHeightUtils = _ref3.rowHeightUtils;
  var _useContext = (0, _react.useContext)(_sorting.DataGridSortedContext),
    getCorrectRowIndex = _useContext.getCorrectRowIndex;

  // `minRowHeight` is primarily used by undefined & lineCount heights
  // and ignored by auto & static heights (unless the static height is < the min)
  var _useState3 = (0, _react.useState)(DEFAULT_ROW_HEIGHT),
    _useState4 = _slicedToArray(_useState3, 2),
    minRowHeight = _useState4[0],
    setRowHeight = _useState4[1];

  // Default/fallback height for all rows
  var defaultRowHeight = (0, _react.useMemo)(function () {
    return rowHeightsOptions !== null && rowHeightsOptions !== void 0 && rowHeightsOptions.defaultHeight ? rowHeightUtils.getCalculatedHeight(rowHeightsOptions.defaultHeight, minRowHeight) : minRowHeight;
  }, [rowHeightsOptions, minRowHeight, rowHeightUtils]);

  // Used by react-window's Grid component to determine actual row heights
  var getRowHeight = (0, _react.useCallback)(function (rowIndex) {
    var correctRowIndex = getCorrectRowIndex(rowIndex);
    var rowHeight;

    // Account for row-specific height overrides
    var rowHeightOption = rowHeightUtils.getRowHeightOption(correctRowIndex, rowHeightsOptions);
    if (rowHeightOption) {
      rowHeight = rowHeightUtils.getCalculatedHeight(rowHeightOption, minRowHeight, correctRowIndex, rowHeightUtils.isRowHeightOverride(correctRowIndex, rowHeightsOptions));
    }

    // Use the row-specific height if it exists, if not, fall back to the default
    return rowHeight || defaultRowHeight;
  }, [minRowHeight, rowHeightsOptions, getCorrectRowIndex, rowHeightUtils, defaultRowHeight]);
  return {
    defaultRowHeight: defaultRowHeight,
    setRowHeight: setRowHeight,
    getRowHeight: getRowHeight
  };
};