"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _react = _interopRequireWildcard(require("react"));
var _index = require("./index");
var _faker = require("@faker-js/faker");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />
var columns = [{
  id: 'Name'
}, {
  id: 'Email',
  cellActions: [function (_ref) {
    var rowIndex = _ref.rowIndex,
      columnId = _ref.columnId,
      Component = _ref.Component;
    var row = ++rowIndex;
    return (0, _react2.jsx)(Component, {
      onClick: function onClick() {},
      iconType: "heart",
      "aria-label": "Send love to ".concat(row, ", column \"").concat(columnId, "\" ")
    }, "Send love");
  }]
}, {
  id: 'User ID',
  schema: 'string'
}, {
  id: 'Account balance'
}, {
  id: 'Last purchase',
  schema: 'datetime'
}, {
  id: 'Favorite distro',
  schema: 'favoriteDistro'
}];
var storeData = [];
for (var i = 1; i < 11; i++) {
  storeData.push({
    Name: "".concat(_faker.faker.person.lastName(), ", ").concat(_faker.faker.person.firstName(), " ").concat(_faker.faker.person.suffix()),
    Email: "".concat(_faker.faker.internet.email()),
    'User ID': "".concat(_faker.faker.number.int({
      min: 1000000,
      max: 9999999
    })),
    'Account balance': _faker.faker.finance.amount(),
    'Last purchase': "".concat(_faker.faker.date.past()),
    'Favorite distro': i % 2 === 0 ? 'Alma' : 'Debian'
  });
}
var commaSeparateNumbers = function commaSeparateNumbers(numberString) {
  // extract the groups-of-three digits that are right-aligned
  return numberString.replace(/((\d{3})+)$/, function (match) {
    return (
      // then replace each group of xyz digits with ,xyz
      match.replace(/(\d{3})/g, ',$1')
    );
  });
};
var renderCellValue = function renderCellValue(_ref2) {
  var rowIndex = _ref2.rowIndex,
    columnId = _ref2.columnId,
    schema = _ref2.schema;
  var value = storeData[rowIndex][columnId];
  if (schema === 'numeric') {
    value = commaSeparateNumbers(value);
  }
  return value;
};
var DataGrid = function DataGrid() {
  var _useState = (0, _react.useState)(columns.map(function (_ref3) {
      var id = _ref3.id;
      return id;
    })),
    _useState2 = _slicedToArray(_useState, 2),
    visibleColumns = _useState2[0],
    setVisibleColumns = _useState2[1];
  var _useState3 = (0, _react.useState)(storeData),
    _useState4 = _slicedToArray(_useState3, 2),
    data = _useState4[0],
    setData = _useState4[1];
  var _useState5 = (0, _react.useState)([{
      id: 'custom',
      direction: 'asc'
    }]),
    _useState6 = _slicedToArray(_useState5, 2),
    sortingColumns = _useState6[0],
    setSortingColumns = _useState6[1];
  var setSorting = function setSorting(sortingColumns) {
    var sortedData = _toConsumableArray(data).sort(function (a, b) {
      for (var _i = 0; _i < sortingColumns.length; _i++) {
        var column = sortingColumns[_i];
        var aValue = a[column.id];
        var bValue = b[column.id];
        if (aValue < bValue) return column.direction === 'asc' ? -1 : 1;
        if (aValue > bValue) return column.direction === 'asc' ? 1 : -1;
      }
      return 0;
    });
    setData(sortedData);
    setSortingColumns(sortingColumns);
  };
  return (0, _react2.jsx)(_index.EuiDataGrid, {
    "aria-label": "Data grid schema example",
    columns: columns,
    columnVisibility: {
      visibleColumns: visibleColumns,
      setVisibleColumns: setVisibleColumns
    },
    rowCount: data.length,
    inMemory: {
      level: 'sorting'
    },
    renderCellValue: renderCellValue,
    sorting: {
      columns: sortingColumns,
      onSort: setSorting
    },
    schemaDetectors: [{
      type: 'favoriteDistro',
      textTransform: 'capitalize',
      detector: function detector(value) {
        return value.toLowerCase() === 'alma' || value.toLowerCase() === 'debian' ? 1 : 0;
      },
      comparator: function comparator(a, b, direction) {
        var aValue = a.toLowerCase() === 'alma';
        var bValue = b.toLowerCase() === 'alma';
        if (aValue < bValue) return direction === 'asc' ? 1 : -1;
        if (aValue > bValue) return direction === 'asc' ? -1 : 1;
        return 0;
      },
      sortTextAsc: 'Alma to Debian',
      sortTextDesc: 'Debian to Alma',
      icon: 'starFilled',
      color: '#800080'
    }]
  });
};
beforeEach(function () {
  cy.viewport(1280, 800); // large breakpoint
  cy.mount((0, _react2.jsx)("div", {
    style: {
      width: '80%',
      margin: '0 auto'
    }
  }, (0, _react2.jsx)(DataGrid, null)));
});
describe('EuiDataGrid', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the columns visibility menu is open', function () {
      cy.get('button[data-test-subj="dataGridColumnSelectorButton"]').realClick();
      cy.checkAxe();
    });
    it('has zero violations when the hide all columns button is clicked', function () {
      cy.get('button[data-test-subj="dataGridColumnSelectorButton"]').realClick();
      cy.get('button[data-test-subj="dataGridColumnSelectorHideAllButton"]').realClick();
      // TODO: Log this issue and remove the skipFailures boolean when fixed
      cy.checkAxe({
        skipFailures: true
      });
    });
    it('has zero violations when the columns reorder searchbox returns multiple results', function () {
      cy.get('button[data-test-subj="dataGridColumnSelectorButton"]').realClick();
      cy.get('input[data-test-subj="dataGridColumnSelectorSearch"]').type('a');
      cy.get('div.euiSwitch--compressed').should(function ($s) {
        expect($s).to.have.length(5);
      });
      cy.checkAxe();
    });
    it('has zero violations when the columns reorder searchbox returns 1 result', function () {
      cy.get('button[data-test-subj="dataGridColumnSelectorButton"]').realClick();
      cy.get('input[data-test-subj="dataGridColumnSelectorSearch"]').type('favorite');
      cy.get('div.euiSwitch--compressed').should(function ($s) {
        expect($s).to.have.length(1);
      });
      cy.checkAxe();
    });
    it('has zero violations when the columns reorder searchbox returns 0 results', function () {
      cy.get('button[data-test-subj="dataGridColumnSelectorButton"]').realClick();
      cy.get('input[data-test-subj="dataGridColumnSelectorSearch"]').type('x');
      cy.get('div.euiSwitch--compressed').should(function ($s) {
        expect($s).to.have.length(0);
      });
      cy.checkAxe();
    });
    it('has zero violations when the keyboard shortcut menu is open', function () {
      cy.get('button[data-test-subj="dataGridKeyboardShortcutsButton"]').realClick();
      cy.checkAxe();
    });
    it('has zero violations when the grid display menu is open', function () {
      cy.get('button[data-test-subj="dataGridDisplaySelectorButton"]').realClick();
      cy.checkAxe();
    });
    it('has zero violations when the column actions menu is open', function () {
      cy.get('button.euiDataGridHeaderCell__button').first().realClick();
      cy.checkAxe();
    });
    it('has zero violations when a cell expansion popover is open', function () {
      cy.get('div[data-gridcell-visible-row-index="0"][data-gridcell-column-index="1"]').realClick();
      cy.get('div[data-gridcell-visible-row-index="0"][data-gridcell-column-index="1"]').find('button.euiButtonIcon').last().realClick();
      cy.checkAxe();
    });
    it('has zero violations on sort and when the columns sorting menu is open', function () {
      cy.get('button.euiDataGridHeaderCell__button').last().realClick();
      cy.get('button.euiListGroupItem__button').contains('Sort Alma to Debian').should('exist').realClick();
      cy.get('div[data-test-subj="dataGridColumnSortingPopover"] button').realClick();
      cy.checkAxe();
    });
    it('has zero violations when fullscreen is open', function () {
      cy.get('button[data-test-subj="dataGridFullScreenButton"]').realClick();
      cy.get('div.euiDataGrid--fullScreen').should('exist');
      cy.checkAxe();
    });
  });
});