"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridDisplaySelector = exports.startingStyles = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _popover = require("../../popover");
var _button = require("../../button");
var _form = require("../../form");
var _flex = require("../../flex");
var _tool_tip = require("../../tool_tip");
var _data_grid_toolbar = require("./data_grid_toolbar");
var _react2 = require("@emotion/react");
var _excluded = ["onChange"],
  _excluded2 = ["onChange"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var startingStyles = exports.startingStyles = {
  cellPadding: 'm',
  fontSize: 'm',
  border: 'all',
  stripes: false,
  rowHover: 'highlight',
  header: 'shade',
  footer: 'overline',
  stickyFooter: true
};

// These are the available options. They power the gridDensity hook and also the options in the render
var densityOptions = ['compact', 'normal', 'expanded'];
var densityStyles = {
  expanded: {
    fontSize: 'l',
    cellPadding: 'l'
  },
  normal: {
    fontSize: 'm',
    cellPadding: 'm'
  },
  compact: {
    fontSize: 's',
    cellPadding: 's'
  }
};
var convertGridStylesToSelection = function convertGridStylesToSelection(gridStyles) {
  if (gridStyles.fontSize === 's' && gridStyles.cellPadding === 's') return 'compact';
  if (gridStyles.fontSize === 'm' && gridStyles.cellPadding === 'm') return 'normal';
  if (gridStyles.fontSize === 'l' && gridStyles.cellPadding === 'l') return 'expanded';
  return '';
};

// Row height options and utilities
var rowHeightButtonOptions = ['undefined', 'auto', 'lineCount'];
var convertRowHeightsOptionsToSelection = function convertRowHeightsOptionsToSelection(rowHeightsOptions) {
  var defaultHeight = rowHeightsOptions.defaultHeight;
  if (defaultHeight === 'auto') {
    return rowHeightButtonOptions[1];
  }
  if (_typeof(defaultHeight) === 'object' && defaultHeight !== null && defaultHeight !== void 0 && defaultHeight.lineCount) {
    return rowHeightButtonOptions[2];
  }
  if (typeof defaultHeight === 'number' || _typeof(defaultHeight) === 'object' && defaultHeight.height) {
    return '';
  }
  return rowHeightButtonOptions[0];
};
var defaultLineCountValue = String(2);
var useDataGridDisplaySelector = exports.useDataGridDisplaySelector = function useDataGridDisplaySelector(showDisplaySelector, initialStyles, initialRowHeightsOptions) {
  var _showDisplaySelector$, _rowHeightsOptions$de2;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var showDensityControls = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowDensity');
  var showRowHeightControls = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowRowHeight');
  var allowResetButton = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowResetButton');
  var additionalDisplaySettings = typeof showDisplaySelector === 'boolean' ? null : (_showDisplaySelector$ = showDisplaySelector === null || showDisplaySelector === void 0 ? void 0 : showDisplaySelector.additionalDisplaySettings) !== null && _showDisplaySelector$ !== void 0 ? _showDisplaySelector$ : null;

  // Track styles specified by the user at run time
  var _useState3 = (0, _react.useState)({}),
    _useState4 = _slicedToArray(_useState3, 2),
    userGridStyles = _useState4[0],
    setUserGridStyles = _useState4[1];
  var _useState5 = (0, _react.useState)({}),
    _useState6 = _slicedToArray(_useState5, 2),
    userRowHeightsOptions = _useState6[0],
    setUserRowHeightsOptions = _useState6[1];

  // Density logic
  var setGridStyles = (0, _react.useCallback)(function (density) {
    setUserGridStyles(densityStyles[density]);
  }, []);

  // Row height logic
  var _useState7 = (0, _react.useState)(defaultLineCountValue),
    _useState8 = _slicedToArray(_useState7, 2),
    lineCountInput = _useState8[0],
    setLineCountInput = _useState8[1];
  var setRowHeight = (0, _react.useCallback)(function (option) {
    var rowHeightsOptions = {
      rowHeights: {} // Unset all row-specific heights
    };
    if (option === 'auto') {
      rowHeightsOptions.defaultHeight = 'auto';
    } else if (option === 'lineCount') {
      rowHeightsOptions.defaultHeight = {
        lineCount: Number(lineCountInput)
      };
    } else {
      rowHeightsOptions.defaultHeight = undefined;
    }
    setUserRowHeightsOptions(rowHeightsOptions);
  }, [lineCountInput]);
  var setLineCountHeight = (0, _react.useCallback)(function (event) {
    setLineCountInput(event.currentTarget.value);
    var newLineCount = Number(event.currentTarget.value);

    // Don't let users set a 0 or negative line count
    if (newLineCount > 0) {
      setUserRowHeightsOptions({
        rowHeights: {},
        // Unset all row-specific line counts
        defaultHeight: {
          lineCount: newLineCount
        }
      });
    }
  }, []);

  // Merge the developer-specified configurations with user overrides
  var gridStyles = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, initialStyles), userGridStyles);
  }, [initialStyles, userGridStyles]);
  var rowHeightsOptions = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, initialRowHeightsOptions), userRowHeightsOptions);
  }, [initialRowHeightsOptions, userRowHeightsOptions]);

  // Set UI controls based on current configurations, on init & when either developer or user settings change
  var gridDensity = (0, _react.useMemo)(function () {
    return convertGridStylesToSelection(gridStyles);
  }, [gridStyles]);
  var rowHeightSelection = (0, _react.useMemo)(function () {
    return convertRowHeightsOptionsToSelection(rowHeightsOptions);
  }, [rowHeightsOptions]);
  (0, _react.useEffect)(function () {
    var _rowHeightsOptions$de;
    setLineCountInput(
    // @ts-ignore - optional chaining operator handles types & cases that aren't lineCount
    (rowHeightsOptions === null || rowHeightsOptions === void 0 || (_rowHeightsOptions$de = rowHeightsOptions.defaultHeight) === null || _rowHeightsOptions$de === void 0 ? void 0 : _rowHeightsOptions$de.lineCount) || defaultLineCountValue);
    // @ts-ignore - same as above
  }, [rowHeightsOptions === null || rowHeightsOptions === void 0 || (_rowHeightsOptions$de2 = rowHeightsOptions.defaultHeight) === null || _rowHeightsOptions$de2 === void 0 ? void 0 : _rowHeightsOptions$de2.lineCount]);

  // Show a reset button whenever users manually change settings, and
  // invoke onChange callbacks (removing the callback value itself, so that only configuration values are returned)
  var _useState9 = (0, _react.useState)(false),
    _useState10 = _slicedToArray(_useState9, 2),
    showResetButton = _useState10[0],
    setShowResetButton = _useState10[1];
  (0, _services.useUpdateEffect)(function () {
    var _initialStyles$onChan;
    if (allowResetButton) {
      var hasUserChanges = Object.keys(userGridStyles).length > 0;
      if (hasUserChanges) setShowResetButton(true);
    }
    var onChange = gridStyles.onChange,
      currentGridStyles = _objectWithoutProperties(gridStyles, _excluded);
    initialStyles === null || initialStyles === void 0 || (_initialStyles$onChan = initialStyles.onChange) === null || _initialStyles$onChan === void 0 || _initialStyles$onChan.call(initialStyles, currentGridStyles);
  }, [userGridStyles, allowResetButton]);
  (0, _services.useUpdateEffect)(function () {
    var _initialRowHeightsOpt;
    if (allowResetButton) {
      var hasUserChanges = Object.keys(userRowHeightsOptions).length > 0;
      if (hasUserChanges) setShowResetButton(true);
    }
    var onChange = rowHeightsOptions.onChange,
      currentRowHeightsOptions = _objectWithoutProperties(rowHeightsOptions, _excluded2);
    initialRowHeightsOptions === null || initialRowHeightsOptions === void 0 || (_initialRowHeightsOpt = initialRowHeightsOptions.onChange) === null || _initialRowHeightsOpt === void 0 || _initialRowHeightsOpt.call(initialRowHeightsOptions, currentRowHeightsOptions);
  }, [userRowHeightsOptions, allowResetButton]);

  // Allow resetting to initial developer-specified configurations
  var resetToInitialState = (0, _react.useCallback)(function () {
    setUserGridStyles({});
    setUserRowHeightsOptions({});
    setShowResetButton(false);
  }, []);
  var buttonLabel = (0, _i18n.useEuiI18n)('euiDisplaySelector.buttonText', 'Display options');
  var resetButtonLabel = (0, _i18n.useEuiI18n)('euiDisplaySelector.resetButtonText', 'Reset to default');
  var displaySelector = (0, _react.useMemo)(function () {
    return showDensityControls || showRowHeightControls || additionalDisplaySettings ? (0, _react2.jsx)(_popover.EuiPopover, {
      "data-test-subj": "dataGridDisplaySelectorPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downRight",
      panelPaddingSize: "s",
      panelClassName: "euiDataGrid__displayPopoverPanel",
      button: (0, _react2.jsx)(_tool_tip.EuiToolTip, {
        content: buttonLabel,
        delay: "long"
      }, (0, _react2.jsx)(_button.EuiButtonIcon, {
        size: "xs",
        iconType: "controlsHorizontal",
        color: "text",
        "data-test-subj": "dataGridDisplaySelectorButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        },
        "aria-label": buttonLabel
      }))
    }, showDensityControls && (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiDisplaySelector.densityLabel', 'euiDisplaySelector.labelCompact', 'euiDisplaySelector.labelNormal', 'euiDisplaySelector.labelExpanded'],
      defaults: ['Density', 'Compact', 'Normal', 'Expanded']
    }, function (_ref) {
      var _ref2 = _slicedToArray(_ref, 4),
        densityLabel = _ref2[0],
        labelCompact = _ref2[1],
        labelNormal = _ref2[2],
        labelExpanded = _ref2[3];
      return (0, _react2.jsx)(_form.EuiFormRow, {
        label: densityLabel,
        display: "columnCompressed"
      }, (0, _react2.jsx)(_button.EuiButtonGroup, {
        legend: densityLabel,
        buttonSize: "compressed",
        isFullWidth: true,
        options: [{
          id: densityOptions[0],
          label: labelCompact
        }, {
          id: densityOptions[1],
          label: labelNormal
        }, {
          id: densityOptions[2],
          label: labelExpanded
        }],
        onChange: setGridStyles,
        idSelected: gridDensity,
        "data-test-subj": "densityButtonGroup"
      }));
    }), showRowHeightControls && (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiDisplaySelector.rowHeightLabel', 'euiDisplaySelector.labelSingle', 'euiDisplaySelector.labelAuto', 'euiDisplaySelector.labelCustom', 'euiDisplaySelector.lineCountLabel'],
      defaults: ['Row height', 'Single', 'Auto fit', 'Custom', 'Lines per row']
    }, function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 5),
        rowHeightLabel = _ref4[0],
        labelSingle = _ref4[1],
        labelAuto = _ref4[2],
        labelCustom = _ref4[3],
        lineCountLabel = _ref4[4];
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_form.EuiFormRow, {
        label: rowHeightLabel,
        display: "columnCompressed"
      }, (0, _react2.jsx)(_button.EuiButtonGroup, {
        legend: rowHeightLabel,
        buttonSize: "compressed",
        isFullWidth: true,
        options: [{
          id: rowHeightButtonOptions[0],
          label: labelSingle
        }, {
          id: rowHeightButtonOptions[1],
          label: labelAuto
        }, {
          id: rowHeightButtonOptions[2],
          label: labelCustom
        }],
        onChange: setRowHeight,
        idSelected: rowHeightSelection,
        "data-test-subj": "rowHeightButtonGroup"
      })), rowHeightSelection === rowHeightButtonOptions[2] && (0, _react2.jsx)(_form.EuiFormRow, {
        label: lineCountLabel,
        display: "columnCompressed"
      }, (0, _react2.jsx)(_form.EuiRange, {
        compressed: true,
        fullWidth: true,
        showInput: true,
        min: 1,
        max: 20,
        step: 1,
        required: true,
        value: lineCountInput,
        onChange: setLineCountHeight,
        "data-test-subj": "lineCountNumber"
      })));
    }), additionalDisplaySettings, showResetButton && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      justifyContent: "flexEnd",
      responsive: false
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)("div", null, (0, _react2.jsx)(_button.EuiButtonEmpty, {
      flush: "both",
      size: "xs",
      onClick: resetToInitialState,
      "data-test-subj": "resetDisplaySelector"
    }, resetButtonLabel)))))) : null;
  }, [additionalDisplaySettings, buttonLabel, isOpen, resetButtonLabel, showDensityControls, showResetButton, showRowHeightControls, gridDensity, rowHeightSelection, lineCountInput, setGridStyles, setRowHeight, setLineCountHeight, resetToInitialState]);
  return [displaySelector, gridStyles, rowHeightsOptions];
};