"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridHeaderCellWrapper = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _focus = require("../../utils/focus");
var _focus_utils = require("../cell/focus_utils");
var _react2 = require("@emotion/react");
var _excluded = ["id", "index", "width", "className", "children", "hasActionsPopover", "isActionsButtonFocused", "focusActionsButton"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * This is a wrapper that handles repeated concerns between control &
 * standard header cells. Most of its shared logic is around focus state/UX,
 * but it also DRY's out certain class/data-test-subj/style attributes
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiDataGridHeaderCellWrapper = exports.EuiDataGridHeaderCellWrapper = function EuiDataGridHeaderCellWrapper(_ref) {
  var id = _ref.id,
    index = _ref.index,
    width = _ref.width,
    className = _ref.className,
    children = _ref.children,
    hasActionsPopover = _ref.hasActionsPopover,
    isActionsButtonFocused = _ref.isActionsButtonFocused,
    focusActionsButton = _ref.focusActionsButton,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiDataGridHeaderCell', className);

  // Must be a state and not a ref to trigger a HandleInteractiveChildren rerender
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    headerEl = _useState2[0],
    setHeaderEl = _useState2[1];
  var _useContext = (0, _react.useContext)(_focus.DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell,
    onFocusUpdate = _useContext.onFocusUpdate;
  var updateCellFocusContext = (0, _react.useCallback)(function () {
    setFocusedCell([index, -1]);
  }, [index, setFocusedCell]);
  var _useState3 = (0, _react.useState)(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isFocused = _useState4[0],
    setIsFocused = _useState4[1];
  (0, _react.useEffect)(function () {
    onFocusUpdate([index, -1], function (isFocused) {
      setIsFocused(isFocused);
      if (isFocused && headerEl) {
        // Only focus the cell if not already focused on something in the cell
        if (!headerEl.contains(document.activeElement)) {
          headerEl.focus();
        }
      }
    });
  }, [index, onFocusUpdate, headerEl]);

  // For cell headers with actions, auto-focus into the button instead of the cell wrapper div
  // The button text is significantly more useful to screen readers (e.g. contains sort order & hints)
  var onFocus = (0, _react.useCallback)(function (e) {
    if (hasActionsPopover && e.target === headerEl) {
      focusActionsButton === null || focusActionsButton === void 0 || focusActionsButton();
    }
  }, [hasActionsPopover, focusActionsButton, headerEl]);
  return (0, _react2.jsx)("div", _extends({
    role: "columnheader",
    ref: setHeaderEl,
    tabIndex: isFocused && !isActionsButtonFocused ? 0 : -1,
    onFocus: onFocus,
    className: classes,
    "data-test-subj": "dataGridHeaderCell-".concat(id),
    "data-gridcell-column-id": id,
    "data-gridcell-column-index": index,
    "data-gridcell-row-index": "-1",
    "data-gridcell-visible-row-index": "-1",
    style: width != null ? {
      width: "".concat(width, "px")
    } : {}
  }, rest), (0, _react2.jsx)(_focus_utils.HandleInteractiveChildren, {
    cellEl: headerEl,
    updateCellFocusContext: updateCellFocusContext,
    renderFocusTrap: !hasActionsPopover
  }, children));
};
EuiDataGridHeaderCellWrapper.propTypes = {
  id: _propTypes.default.string.isRequired,
  index: _propTypes.default.number.isRequired,
  width: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.oneOf([null])]),
  className: _propTypes.default.string,
  hasActionsPopover: _propTypes.default.bool,
  isActionsButtonFocused: _propTypes.default.bool,
  focusActionsButton: _propTypes.default.func
};