"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiButtonDisplayStyles = exports.euiButtonBaseCSS = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _mixins = require("../../../themes/amsterdam/global_styling/mixins");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Provides a solid reset and base for handling sizing layout
// Does not include any visual styles
var euiButtonBaseCSS = exports.euiButtonBaseCSS = function euiButtonBaseCSS() {
  return "\n    display: inline-block;\n    appearance: none;\n    cursor: pointer;\n    ".concat((0, _global_styling.logicalTextAlignStyle)('center'), ";\n    white-space: nowrap;\n    ").concat((0, _global_styling.logicalCSS)('max-width', '100%'), ";\n    vertical-align: middle;\n  ");
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;"
} : {
  name: "8595p9-isDisabled",
  styles: "cursor:not-allowed;label:isDisabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiButtonDisplayStyles = exports.euiButtonDisplayStyles = function euiButtonDisplayStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var sizes = (0, _mixins.euiButtonSizeMap)(euiThemeContext);
  var _buttonSize = function _buttonSize(sizeKey) {
    var size = sizes[sizeKey];
    return /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', size.height), " line-height:", size.height, ";", (0, _global_styling.euiFontSize)(euiThemeContext, size.fontScale), " border-radius:", size.radius, ";");
  };
  return {
    // Base
    euiButtonDisplay: /*#__PURE__*/(0, _react.css)(euiButtonBaseCSS(), " font-weight:", euiTheme.font.weight.medium, ";", (0, _global_styling.logicalShorthandCSS)('padding', "0 ".concat(euiTheme.size.m)), " &:hover:not(:disabled),&:focus{text-decoration:underline;};label:euiButtonDisplay;"),
    // States
    isDisabled: _ref,
    fullWidth: /*#__PURE__*/(0, _react.css)("display:block;", (0, _global_styling.logicalCSS)('width', '100%'), ";;label:fullWidth;"),
    defaultMinWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('min-width', "".concat(euiTheme.base * 7, "px")), ";;label:defaultMinWidth;"),
    // Sizes
    xs: /*#__PURE__*/(0, _react.css)(_buttonSize('xs'), ";label:xs;"),
    s: /*#__PURE__*/(0, _react.css)(_buttonSize('s'), ";label:s;"),
    m: /*#__PURE__*/(0, _react.css)(_buttonSize('m'), ";label:m;")
  };
};