"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBeaconStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject, _templateObject2;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
var _colorCSS = function _colorCSS(color) {
  return "\n    background-color: ".concat(color, ";\n    &:before,\n    &:after {\n      box-shadow: 0 0 1px 1px ").concat(color, ";\n    }\n  ");
};
var euiBeaconPulseLarge = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n 0% {\n    transform: scale(.1);\n    opacity: 1;\n  }\n\n  70% {\n    transform: scale(3);\n    opacity: 0;\n  }\n\n  100% {\n    opacity: 0;\n  }\n"])));
var euiBeaconPulseSmall = (0, _react.keyframes)(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n   0% {\n    transform: scale(.1);\n    opacity: 1;\n  }\n\n  70% {\n    transform: scale(2);\n    opacity: 0;\n  }\n\n  100% {\n    opacity: 0;\n  }\n"])));
var euiBeaconStyles = exports.euiBeaconStyles = function euiBeaconStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    // Base
    euiBeacon: /*#__PURE__*/(0, _react.css)("position:relative;border-radius:50%;&::before,&::after{position:absolute;content:'';", (0, _global_styling.logicalSizeCSS)('100%', '100%'), " ", (0, _global_styling.logicalCSS)('left', 0), " ", (0, _global_styling.logicalCSS)('top', 0), " background-color:transparent;border-radius:50%;}&::before{transform:scale(1.6);opacity:0.4;}&::after{opacity:0;}", _global_styling.euiCanAnimate, "{&::before{animation:", euiBeaconPulseLarge, " 2.5s infinite ease-out;}&::after{animation:", euiBeaconPulseSmall, " 2.5s infinite ease-out 0.25s;}};label:euiBeacon;"),
    subdued: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.subduedText), ";label:subdued;"),
    primary: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.primary), ";label:primary;"),
    success: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.success), ";label:success;"),
    warning: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.warning), ";label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.danger), ";label:danger;"),
    accent: /*#__PURE__*/(0, _react.css)(_colorCSS(euiTheme.colors.accent), ";label:accent;")
  };
};