"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiNotificationBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _color_utils = require("../color_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiNotificationBadgeStyles = exports.euiNotificationBadgeStyles = function euiNotificationBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var badgeColors = (0, _color_utils.euiBadgeColors)(euiThemeContext);
  return {
    euiNotificationBadge: /*#__PURE__*/(0, _react.css)("flex-shrink:0;display:inline-block;vertical-align:middle;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), " border-radius:", euiTheme.border.radius.small, ";cursor:default;font-size:", (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme), ";font-weight:", euiTheme.font.weight.medium, ";", (0, _global_styling.euiNumberFormat)(euiThemeContext), " text-align:center;", _global_styling.euiCanAnimate, "{transition:all ", euiTheme.animation.fast, " ease-in;};label:euiNotificationBadge;"),
    // Sizes
    s: /*#__PURE__*/(0, _react.css)("line-height:", euiTheme.size.base, ";", (0, _global_styling.logicalCSS)('height', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('min-width', euiTheme.size.base), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("line-height:", (0, _global_styling.mathWithUnits)(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    }), ";", (0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    })), " ", (0, _global_styling.logicalCSS)('min-width', euiTheme.size.l), ";;label:m;"),
    // Colors
    accent: /*#__PURE__*/(0, _react.css)(badgeColors.accentText, ";label:accent;"),
    success: /*#__PURE__*/(0, _react.css)(badgeColors.success, ";label:success;"),
    subdued: /*#__PURE__*/(0, _react.css)(badgeColors.subdued, ";label:subdued;")
  };
};