"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFixedChartSize = exports.getChartSize = void 0;
function getChartSize(size) {
    if (Array.isArray(size)) {
        return {
            width: size[0] === undefined ? '100%' : size[0],
            height: size[1] === undefined ? '100%' : size[1],
        };
    }
    if (typeof size === 'object') {
        return {
            width: size.width === undefined ? '100%' : size.width,
            height: size.height === undefined ? '100%' : size.height,
        };
    }
    const sameSize = size === undefined ? '100%' : size;
    return {
        width: sameSize,
        height: sameSize,
    };
}
exports.getChartSize = getChartSize;
function getFixedChartSize(size) {
    const { width, height } = getChartSize(size);
    return typeof height === 'number' && typeof width === 'number' ? { width, height } : null;
}
exports.getFixedChartSize = getFixedChartSize;
//# sourceMappingURL=chart_size.js.map