"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegendListItem = exports.prepareLegendValues = exports.LEGEND_HIERARCHY_MARGIN = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importStar(require("react"));
const label_1 = require("./label");
const legend_color_picker_1 = require("./legend_color_picker");
const utils_1 = require("./utils");
const legend_1 = require("../../common/legend");
const common_1 = require("../../utils/common");
exports.LEGEND_HIERARCHY_MARGIN = 10;
const prepareLegendValues = (item, legendValues, totalItems, extraValues) => {
    return legendValues.map((legendValue) => {
        if (legendValue === legend_1.LegendValue.Value || legendValue === legend_1.LegendValue.CurrentAndLastValue) {
            return (0, utils_1.getExtra)(extraValues, item, totalItems);
        }
        return item.values.find(({ type }) => type === legendValue);
    });
};
exports.prepareLegendValues = prepareLegendValues;
const LegendListItem = (props) => {
    const { extraValues, item, legendValues, totalItems, action: Action, positionConfig, labelOptions, isMostlyRTL, flatLegend, onClick, toggleDeselectSeriesAction, hiddenItems, onLegendItemMouseOver, onLegendItemMouseOut, } = props;
    const { color, isSeriesHidden, isItemHidden, seriesIdentifiers, label, depth, path, isToggleable } = item;
    const itemClassNames = (0, classnames_1.default)('echLegendItem', {
        'echLegendItem--hidden': isSeriesHidden,
        'echLegendItem--vertical': positionConfig.direction === common_1.LayoutDirection.Vertical,
    });
    const legendValueItems = (0, exports.prepareLegendValues)(item, legendValues, totalItems, extraValues).filter(common_1.isDefined);
    const style = flatLegend
        ? {}
        : {
            [isMostlyRTL ? 'marginRight' : 'marginLeft']: exports.LEGEND_HIERARCHY_MARGIN * (depth !== null && depth !== void 0 ? depth : 0),
        };
    const onLabelToggle = (0, react_1.useCallback)((legendItemId) => (negate) => {
        if (totalItems <= 1 || (!isToggleable && !onClick)) {
            return;
        }
        if (onClick) {
            onClick(legendItemId);
        }
        if (isToggleable) {
            toggleDeselectSeriesAction(legendItemId, negate);
        }
    }, [onClick, toggleDeselectSeriesAction, isToggleable, totalItems]);
    const { renderItemColor, renderColorPickerPopup } = (0, legend_color_picker_1.useLegendColorPicker)(props);
    if (isItemHidden)
        return null;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("li", { className: itemClassNames, onMouseEnter: () => onLegendItemMouseOver(seriesIdentifiers, path), onMouseLeave: onLegendItemMouseOut, style: style, dir: isMostlyRTL ? 'rtl' : 'ltr', "data-ech-series-name": label },
            react_1.default.createElement("div", { className: "background" }),
            react_1.default.createElement("div", { className: "echLegend__colorWrapper" }, renderItemColor()),
            react_1.default.createElement(label_1.Label, { label: label, options: labelOptions, isToggleable: totalItems > 1 && item.isToggleable, onToggle: onLabelToggle(seriesIdentifiers), isSeriesHidden: isSeriesHidden, totalSeriesCount: totalItems, hiddenSeriesCount: hiddenItems }),
            !isSeriesHidden
                ? legendValueItems.map((legendValueItem) => legendValueItem.label !== '' ? (react_1.default.createElement("div", { key: legendValueItem.label, className: "echLegendItem__legendValue" }, legendValueItem.label)) : null)
                : null,
            Action && (react_1.default.createElement("div", { className: "echLegendItem__action" },
                react_1.default.createElement(Action, { series: seriesIdentifiers, color: color, label: label })))),
        renderColorPickerPopup()));
};
exports.LegendListItem = LegendListItem;
//# sourceMappingURL=legend_item.js.map