"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.differencePercent = exports.difference = exports.lastNonNull = exports.firstNonNull = exports.stdDeviation = exports.variance = exports.nonNullArray = exports.distinctCount = exports.countNonNull = exports.range = exports.max = exports.min = exports.median = exports.average = exports.sum = void 0;
function sum(arr, accessor) {
    return arr.reduce((acc, d) => {
        const value = accessor(d);
        return {
            sum: acc.sum + (value !== null ? value : 0),
            validCount: value !== null ? acc.validCount + 1 : acc.validCount,
        };
    }, { sum: 0, validCount: 0 });
}
exports.sum = sum;
function average(arr, accessor) {
    const total = sum(arr, accessor);
    if (total.validCount === 0)
        return NaN;
    return total.sum / total.validCount;
}
exports.average = average;
function median(input, accessor) {
    var _a, _b, _c;
    const arr = input.reduce((acc, d) => {
        const value = accessor(d);
        if (value !== null) {
            acc.push(value);
        }
        return acc;
    }, []);
    if (!arr.length)
        return NaN;
    const s = arr.slice().sort((a, b) => a - b);
    const mid = Math.floor(s.length / 2);
    if (s.length % 2) {
        return (_a = s[mid]) !== null && _a !== void 0 ? _a : NaN;
    }
    return (((_b = s[mid - 1]) !== null && _b !== void 0 ? _b : NaN) + ((_c = s[mid]) !== null && _c !== void 0 ? _c : NaN)) / 2;
}
exports.median = median;
function min(arr, accessor) {
    if (arr.length === 0)
        return NaN;
    return arr.reduce((m, d) => {
        const value = accessor(d);
        return value !== null ? Math.min(m, value) : m;
    }, +Infinity);
}
exports.min = min;
function max(arr, accessor) {
    if (arr.length === 0)
        return NaN;
    return arr.reduce((m, d) => {
        const value = accessor(d);
        return value !== null ? Math.max(m, value) : m;
    }, -Infinity);
}
exports.max = max;
function range(arr, accessor) {
    if (arr.length === 0)
        return NaN;
    const minMax = arr.reduce((m, d) => {
        const value = accessor(d);
        return {
            max: value !== null ? Math.max(m.max, value) : m.max,
            min: value !== null ? Math.min(m.min, value) : m.min,
        };
    }, { min: +Infinity, max: -Infinity });
    return minMax.max - minMax.min;
}
exports.range = range;
function countNonNull(arr, accessor) {
    return arr.filter((d) => accessor(d) !== null).length;
}
exports.countNonNull = countNonNull;
function distinctCount(arr, accessor) {
    return new Set(nonNullArray(arr, accessor)).size;
}
exports.distinctCount = distinctCount;
function nonNullArray(arr, accessor) {
    return arr.reduce((acc, d) => {
        const value = accessor(d);
        if (value !== null) {
            acc.push(value);
        }
        return acc;
    }, []);
}
exports.nonNullArray = nonNullArray;
function variance(arr, accessor) {
    const nonNullArr = nonNullArray(arr, accessor);
    const ddof = 1;
    const total = sum(nonNullArr, (d) => d);
    const avg = total.sum / total.validCount;
    const squareDiffs = nonNullArr.map((d) => {
        return Math.abs(Math.pow(d - avg, 2));
    });
    const totalSumOfSquareDiffs = sum(squareDiffs, (d) => d);
    return totalSumOfSquareDiffs.sum / (totalSumOfSquareDiffs.validCount - ddof);
}
exports.variance = variance;
function stdDeviation(arr, accessor) {
    const v = variance(arr, accessor);
    const std = Math.sqrt(v);
    return std;
}
exports.stdDeviation = stdDeviation;
function firstNonNull(arr, accessor) {
    for (let i = 0; i < arr.length; i++) {
        const item = arr[i];
        if (!item)
            continue;
        const value = accessor(item);
        if (value) {
            return value;
        }
    }
    return null;
}
exports.firstNonNull = firstNonNull;
function lastNonNull(arr, accessor) {
    for (let i = arr.length - 1; i >= 0; i--) {
        const item = arr[i];
        if (!item)
            continue;
        const value = accessor(item);
        if (value) {
            return value;
        }
    }
    return null;
}
exports.lastNonNull = lastNonNull;
function difference(arr, accessor) {
    const first = firstNonNull(arr, accessor);
    const last = lastNonNull(arr, accessor);
    if (first !== null && last !== null) {
        return last - first;
    }
    return null;
}
exports.difference = difference;
function differencePercent(arr, accessor) {
    const first = firstNonNull(arr, accessor);
    const last = lastNonNull(arr, accessor);
    if (first !== null && last !== null) {
        return (last - first) / last;
    }
    return null;
}
exports.differencePercent = differencePercent;
//# sourceMappingURL=aggregations.js.map