"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricText = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const default_theme_attributes_1 = require("../../../../common/default_theme_attributes");
const canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
const common_1 = require("../../../../utils/common");
const wrap_1 = require("../../../../utils/text/wrap");
const specs_1 = require("../../specs");
const PROGRESS_BAR_WIDTH = 10;
const PROGRESS_BAR_TARGET_WIDTH = 4;
const HEIGHT_BP = [
    [0, 200, 'xs'],
    [200, 300, 's'],
    [300, 400, 'm'],
    [400, 500, 'l'],
    [500, 600, 'xl'],
    [600, Infinity, 'xxl'],
];
const PADDING = 8;
const LINE_HEIGHT = 1.2;
const ICON_SIZE = { xs: 16, s: 16, m: 24, l: 24, xl: 32, xxl: 42 };
const TITLE_FONT_SIZE = { xs: 16, s: 16, m: 24, l: 24, xl: 32, xxl: 42 };
const SUBTITLE_FONT_SIZE = { xs: 14, s: 14, m: 16, l: 20, xl: 26, xxl: 36 };
const EXTRA_FONT_SIZE = { xs: 14, s: 14, m: 16, l: 20, xl: 26, xxl: 36 };
const VALUE_FONT_SIZE = { xs: 36, s: 36, m: 56, l: 72, xl: 104, xxl: 170 };
const VALUE_PART_FONT_SIZE = { xs: 24, s: 24, m: 42, l: 56, xl: 80, xxl: 130 };
const VALUE_PART_FONT_RATIO = 1.3;
const TITLE_FONT = {
    fontStyle: 'normal',
    fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
    fontVariant: 'normal',
    fontWeight: 'bold',
    textColor: 'black',
};
const VALUE_FONT = TITLE_FONT;
const SUBTITLE_FONT = {
    ...TITLE_FONT,
    fontWeight: 'normal',
};
function getFontSizes(ranges, value, style) {
    var _a, _b;
    const range = ranges.find(([min, max]) => min <= value && value < max);
    const size = range ? range[2] : (_b = (_a = ranges[0]) === null || _a === void 0 ? void 0 : _a[2]) !== null && _b !== void 0 ? _b : 's';
    const valueFontSize = typeof style.valueFontSize === 'number' ? style.valueFontSize : VALUE_FONT_SIZE[size];
    const valuePartFontSize = typeof style.valueFontSize === 'number'
        ? Math.ceil(valueFontSize / VALUE_PART_FONT_RATIO)
        : VALUE_PART_FONT_SIZE[size];
    return {
        iconSize: ICON_SIZE[size],
        titleFontSize: TITLE_FONT_SIZE[size],
        subtitleFontSize: SUBTITLE_FONT_SIZE[size],
        extraFontSize: EXTRA_FONT_SIZE[size],
        valueFontSize,
        valuePartFontSize,
    };
}
function elementVisibility(datum, panel, sizes, locale, fit) {
    const maxTitlesWidth = 0.95 * panel.width - (datum.icon ? 24 : 0) - 2 * PADDING;
    const titleHeight = (maxLines, textMeasure) => {
        return datum.title
            ? PADDING +
                (0, wrap_1.wrapText)(datum.title, TITLE_FONT, sizes.titleFontSize, maxTitlesWidth, maxLines, textMeasure, locale).length *
                    sizes.titleFontSize *
                    LINE_HEIGHT
            : 0;
    };
    const subtitleHeight = (maxLines, textMeasure) => {
        return datum.subtitle
            ? PADDING +
                (0, wrap_1.wrapText)(datum.subtitle, SUBTITLE_FONT, sizes.subtitleFontSize, maxTitlesWidth, maxLines, textMeasure, locale)
                    .length *
                    sizes.subtitleFontSize *
                    LINE_HEIGHT
            : 0;
    };
    const extraHeight = sizes.extraFontSize * LINE_HEIGHT;
    const valueHeight = sizes.valueFontSize * LINE_HEIGHT;
    const responsiveBreakPoints = [
        { titleMaxLines: 3, subtitleMaxLines: 2, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 3, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 2, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: false },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: false },
    ];
    const getCombinedHeight = ({ titleMaxLines, subtitleMaxLines, title, subtitle, extra }, measure) => (title && titleMaxLines > 0 ? titleHeight(titleMaxLines, measure) : 0) +
        (subtitle && subtitleMaxLines > 0 ? subtitleHeight(subtitleMaxLines, measure) : 0) +
        (extra ? extraHeight : 0) +
        valueHeight +
        PADDING;
    const isVisible = (ev, measure) => getCombinedHeight(ev, measure) < panel.height;
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)((textMeasure) => {
        var _a, _b, _c;
        const visibilityBreakpoint = fit
            ? responsiveBreakPoints.at(0)
            : (_a = responsiveBreakPoints.find((breakpoint) => isVisible(breakpoint, textMeasure))) !== null && _a !== void 0 ? _a : responsiveBreakPoints.at(-1);
        return {
            ...visibilityBreakpoint,
            gapHeight: Math.max(0, panel.height - getCombinedHeight(visibilityBreakpoint, textMeasure)),
            titleLines: (0, wrap_1.wrapText)((_b = datum.title) !== null && _b !== void 0 ? _b : '', TITLE_FONT, sizes.titleFontSize, maxTitlesWidth, visibilityBreakpoint.titleMaxLines, textMeasure, locale),
            subtitleLines: (0, wrap_1.wrapText)((_c = datum.subtitle) !== null && _c !== void 0 ? _c : '', SUBTITLE_FONT, sizes.subtitleFontSize, maxTitlesWidth, visibilityBreakpoint.subtitleMaxLines, textMeasure, locale),
        };
    });
}
function getFitValueFontSize(valueFontSize, maxWidth, gapHeight, textParts, minValueFontSize, hasIcon) {
    const widthConstrainedSize = (0, canvas_text_bbox_calculator_1.withTextMeasure)((textMeasure) => {
        const iconMultiplier = hasIcon ? 1 : 0;
        const textWidth = textParts.reduce((sum, { text, emphasis }) => {
            const fontSize = emphasis === 'small' ? valueFontSize / VALUE_PART_FONT_RATIO : valueFontSize;
            return sum + textMeasure(text, VALUE_FONT, fontSize).width;
        }, 0);
        const ratio = textWidth / valueFontSize;
        return (maxWidth - iconMultiplier * PADDING) / (ratio + iconMultiplier / VALUE_PART_FONT_RATIO);
    });
    const heightConstrainedSize = valueFontSize + gapHeight;
    const fitValueFontSize = Math.max(Math.min(heightConstrainedSize, widthConstrainedSize), minValueFontSize);
    return {
        valueFontSize: fitValueFontSize,
        valuePartFontSize: fitValueFontSize / VALUE_PART_FONT_RATIO,
    };
}
function lineClamp(maxLines) {
    return {
        textOverflow: 'ellipsis',
        display: '-webkit-box',
        WebkitLineClamp: maxLines,
        lineClamp: maxLines,
        WebkitBoxOrient: 'vertical',
        overflow: 'hidden',
        whiteSpace: 'pre-wrap',
    };
}
const MetricText = ({ id, datum, panel, style, onElementClick, highContrastTextColor, progressBarSize, locale }) => {
    var _a, _b;
    const { extra, body } = datum;
    const sizes = getFontSizes(HEIGHT_BP, panel.height, style);
    const hasProgressBar = (0, specs_1.isMetricWProgress)(datum);
    const hasTarget = !(0, common_1.isNil)(datum === null || datum === void 0 ? void 0 : datum.target);
    const progressBarDirection = (0, specs_1.isMetricWProgress)(datum) ? datum.progressBarDirection : undefined;
    const progressBarWidth = hasProgressBar && progressBarDirection === common_1.LayoutDirection.Vertical
        ? PROGRESS_BAR_WIDTH + (hasTarget ? PROGRESS_BAR_TARGET_WIDTH : 0)
        : 0;
    const containerClassName = (0, classnames_1.default)('echMetricText', {
        [`echMetricText--${progressBarSize}`]: hasProgressBar,
        'echMetricText--vertical': progressBarDirection === common_1.LayoutDirection.Vertical,
        'echMetricText--horizontal': progressBarDirection === common_1.LayoutDirection.Horizontal,
    });
    const visibility = elementVisibility(datum, panel, sizes, locale, style.valueFontSize === 'fit');
    const textParts = getTextParts(datum, style);
    const { valueFontSize, valuePartFontSize } = style.valueFontSize !== 'fit'
        ? sizes
        : getFitValueFontSize(sizes.valueFontSize, (panel.width - progressBarWidth - 2 * PADDING) * 0.98, visibility.gapHeight, textParts, style.minValueFontSize, datum.valueIcon !== undefined);
    const TitleElement = () => (react_1.default.createElement("span", { style: {
            fontSize: sizes.titleFontSize,
            textAlign: style.titlesTextAlign,
            ...lineClamp(visibility.titleLines.length),
        }, title: datum.title }, datum.title));
    return (react_1.default.createElement("div", { className: containerClassName, style: { color: highContrastTextColor } },
        react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__titlesBlock', `echMetricText__titlesBlock--${style.titlesTextAlign}`), style: datum.icon && {
                marginLeft: 'center' === style.titlesTextAlign || style.iconAlign === 'left' ? sizes.iconSize + PADDING : 0,
                marginRight: 'center' === style.titlesTextAlign || style.iconAlign === 'right' ? sizes.iconSize + PADDING : 0,
            } },
            visibility.title && (react_1.default.createElement("h2", { id: id, className: "echMetricText__title" }, onElementClick ? (react_1.default.createElement("button", { style: { outline: 'none' }, onMouseDown: (e) => e.stopPropagation(), onMouseUp: (e) => e.stopPropagation(), onClick: (e) => {
                    e.stopPropagation();
                    onElementClick();
                } },
                react_1.default.createElement(TitleElement, null))) : (react_1.default.createElement(TitleElement, null)))),
            visibility.subtitle && (react_1.default.createElement("p", { className: "echMetricText__subtitle", style: {
                    fontSize: sizes.subtitleFontSize,
                    ...lineClamp(visibility.subtitleLines.length),
                }, title: datum.subtitle }, datum.subtitle))),
        datum.icon && (react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__icon', `echMetricText__icon--${style.iconAlign}`) }, (0, common_1.renderWithProps)(datum.icon, {
            width: sizes.iconSize,
            height: sizes.iconSize,
            color: highContrastTextColor,
        }))),
        react_1.default.createElement("div", { className: "echMetricText__gap" }, body && react_1.default.createElement("div", { className: "echMetricText__body" }, body)),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('echMetricText__valuesBlock', `echMetricText__valuesBlock--${style.valuesTextAlign}`) },
            react_1.default.createElement("div", null, visibility.extra && (react_1.default.createElement("p", { className: "echMetricText__extra", style: { fontSize: sizes.extraFontSize } }, extra))),
            react_1.default.createElement("div", { className: "echMetricText__valueGroup" },
                react_1.default.createElement("p", { className: "echMetricText__value", style: {
                        fontSize: valueFontSize,
                        textOverflow: (0, specs_1.isMetricWNumber)(datum) ? undefined : 'ellipsis',
                        color: datum.valueColor,
                    }, title: textParts.map(({ text }) => text).join('') }, textParts.map(({ emphasis, text }, i) => {
                    return emphasis === 'small' ? (react_1.default.createElement("span", { key: `${text}${i}`, className: "echMetricText__part", style: {
                            fontSize: valuePartFontSize,
                        } }, text)) : (text);
                })),
                datum.valueIcon && (react_1.default.createElement("p", { className: "echMetricText__valueIcon", style: {
                        fontSize: valueFontSize,
                        color: (_a = datum.valueColor) !== null && _a !== void 0 ? _a : highContrastTextColor,
                        marginRight: style.valuesTextAlign === 'center' ? -(valuePartFontSize + PADDING) : undefined,
                    } }, (0, common_1.renderWithProps)(datum.valueIcon, {
                    width: valuePartFontSize,
                    height: valuePartFontSize,
                    color: (_b = datum.valueColor) !== null && _b !== void 0 ? _b : highContrastTextColor,
                    verticalAlign: 'middle',
                })))))));
};
exports.MetricText = MetricText;
function getTextParts(datum, style) {
    const values = Array.isArray(datum.value) ? datum.value : [datum.value];
    const valueFormatter = (0, specs_1.isMetricWNumber)(datum) || (0, specs_1.isMetricWNumberArrayValues)(datum) ? datum.valueFormatter : (v) => `${v}`;
    const textParts = values.reduce((acc, value, i, { length }) => {
        const parts = typeof value === 'number'
            ? (0, common_1.isFiniteNumber)(value)
                ? splitNumericSuffixPrefix(valueFormatter(value))
                : [{ emphasis: 'normal', text: style.nonFiniteText }]
            : [{ emphasis: 'normal', text: value }];
        if (i < length - 1) {
            parts.push({ emphasis: 'normal', text: ', ' });
        }
        return [...acc, ...parts];
    }, []);
    if (!Array.isArray(datum.value))
        return textParts;
    return [{ emphasis: 'normal', text: '[' }, ...textParts, { emphasis: 'normal', text: ']' }];
}
function splitNumericSuffixPrefix(text) {
    return text
        .split('')
        .reduce((acc, curr) => {
        var _a, _b;
        const emphasis = curr === '.' || curr === ',' || (0, common_1.isFiniteNumber)(Number.parseInt(curr)) ? 'normal' : 'small';
        if (acc.length > 0 && ((_a = acc.at(-1)) === null || _a === void 0 ? void 0 : _a.emphasis) === emphasis) {
            (_b = acc.at(-1)) === null || _b === void 0 ? void 0 : _b.textParts.push(curr);
        }
        else {
            acc.push({ emphasis, textParts: [curr] });
        }
        return acc;
    }, [])
        .map(({ emphasis, textParts }) => ({
        emphasis,
        text: textParts.join(''),
    }));
}
//# sourceMappingURL=text.js.map