"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTicks = void 0;
const common_1 = require("../../../utils/common");
const constants_1 = require("../renderer/canvas/constants");
function getTicks(length, { desiredTicks, interval }) {
    if (((0, common_1.isFiniteNumber)(desiredTicks) && desiredTicks >= 0) ||
        typeof desiredTicks === 'function' ||
        Array.isArray(desiredTicks)) {
        return desiredTicks;
    }
    const target = Math.floor(length / interval);
    return (0, common_1.clamp)(target, constants_1.MIN_TICK_COUNT, constants_1.MAX_TICK_COUNT);
}
exports.getTicks = getTicks;
//# sourceMappingURL=ticks.js.map