"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEncodingAsync = void 0;
/* eslint-disable import/extensions */
const convertTokenBytePairEncodingFromTuples_js_1 = require("./convertTokenBytePairEncodingFromTuples.js");
const resolveEncodingAsync = async (encoding) => {
    switch (encoding) {
        case 'r50k_base':
            return (0, convertTokenBytePairEncodingFromTuples_js_1.convertTokenBytePairEncodingFromTuples)(await import('./encodings/r50k_base.js').then(({ default: encodingTuples }) => encodingTuples));
        case 'p50k_base':
        case 'p50k_edit':
            return (0, convertTokenBytePairEncodingFromTuples_js_1.convertTokenBytePairEncodingFromTuples)(await import('./encodings/p50k_base.js').then(({ default: encodingTuples }) => encodingTuples));
        case 'cl100k_base':
            return (0, convertTokenBytePairEncodingFromTuples_js_1.convertTokenBytePairEncodingFromTuples)(await import('./encodings/cl100k_base.js').then(({ default: encodingTuples }) => encodingTuples));
        default: {
            throw new Error(`Unknown encoding name: ${encoding}`);
        }
    }
};
exports.resolveEncodingAsync = resolveEncodingAsync;
//# sourceMappingURL=resolveEncodingAsync.js.map