"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEncoding = void 0;
/* eslint-disable import/extensions */
const convertTokenBytePairEncodingFromTuples_js_1 = require("./convertTokenBytePairEncodingFromTuples.js");
const cl100k_base_js_1 = __importDefault(require("./encodings/cl100k_base.js"));
const p50k_base_js_1 = __importDefault(require("./encodings/p50k_base.js"));
const r50k_base_js_1 = __importDefault(require("./encodings/r50k_base.js"));
const resolveEncoding = (encoding) => {
    switch (encoding) {
        case 'r50k_base':
            return (0, convertTokenBytePairEncodingFromTuples_js_1.convertTokenBytePairEncodingFromTuples)(r50k_base_js_1.default);
        case 'p50k_base':
        case 'p50k_edit':
            return (0, convertTokenBytePairEncodingFromTuples_js_1.convertTokenBytePairEncodingFromTuples)(p50k_base_js_1.default);
        case 'cl100k_base':
            return (0, convertTokenBytePairEncodingFromTuples_js_1.convertTokenBytePairEncodingFromTuples)(cl100k_base_js_1.default);
        default: {
            throw new Error(`Unknown encoding name: ${encoding}`);
        }
    }
};
exports.resolveEncoding = resolveEncoding;
//# sourceMappingURL=resolveEncoding.js.map