"use strict";
/* eslint-disable camelcase */
Object.defineProperty(exports, "__esModule", { value: true });
exports.chatModelParams = exports.modelToEncodingMap = exports.encodingNames = exports.r50k_base = exports.p50k_edit = exports.p50k_base = exports.cl100k_base = void 0;
const specialTokens_js_1 = require("./specialTokens.js");
exports.cl100k_base = 'cl100k_base';
exports.p50k_base = 'p50k_base';
exports.p50k_edit = 'p50k_edit';
exports.r50k_base = 'r50k_base';
exports.encodingNames = [
    exports.cl100k_base,
    exports.p50k_base,
    exports.r50k_base,
    exports.p50k_edit,
];
exports.modelToEncodingMap = {
    // chat
    'gpt-4': exports.cl100k_base,
    'gpt-4-32k': exports.cl100k_base,
    'gpt-4-0314': exports.cl100k_base,
    'gpt-4-32k-0314': exports.cl100k_base,
    'gpt-3.5-turbo': exports.cl100k_base,
    'gpt-3.5-turbo-0301': exports.cl100k_base,
    // text
    'text-davinci-003': exports.p50k_base,
    'text-davinci-002': exports.p50k_base,
    'text-davinci-001': exports.r50k_base,
    'text-curie-001': exports.r50k_base,
    'text-babbage-001': exports.r50k_base,
    'text-ada-001': exports.r50k_base,
    davinci: exports.r50k_base,
    curie: exports.r50k_base,
    babbage: exports.r50k_base,
    ada: exports.r50k_base,
    // code
    'code-davinci-002': exports.p50k_base,
    'code-davinci-001': exports.p50k_base,
    'code-cushman-002': exports.p50k_base,
    'code-cushman-001': exports.p50k_base,
    'davinci-codex': exports.p50k_base,
    'cushman-codex': exports.p50k_base,
    // edit
    'text-davinci-edit-001': exports.p50k_edit,
    'code-davinci-edit-001': exports.p50k_edit,
    // embeddings
    'text-embedding-ada-002': exports.cl100k_base,
    // old embeddings
    'text-similarity-davinci-001': exports.r50k_base,
    'text-similarity-curie-001': exports.r50k_base,
    'text-similarity-babbage-001': exports.r50k_base,
    'text-similarity-ada-001': exports.r50k_base,
    'text-search-davinci-doc-001': exports.r50k_base,
    'text-search-curie-doc-001': exports.r50k_base,
    'text-search-babbage-doc-001': exports.r50k_base,
    'text-search-ada-doc-001': exports.r50k_base,
    'code-search-babbage-code-001': exports.r50k_base,
    'code-search-ada-code-001': exports.r50k_base,
};
const internalChatModelParams = {
    'gpt-3.5-turbo': {
        messageSeparator: '\n',
        roleSeparator: '\n',
    },
    'gpt-3.5-turbo-0301': {
        messageSeparator: '\n',
        roleSeparator: '\n',
    },
    'gpt-4': {
        messageSeparator: '',
        roleSeparator: specialTokens_js_1.ImSep,
    },
    'gpt-4-0314': {
        messageSeparator: '',
        roleSeparator: specialTokens_js_1.ImSep,
    },
    'gpt-4-32k': {
        messageSeparator: '',
        roleSeparator: specialTokens_js_1.ImSep,
    },
    'gpt-4-32k-0314': {
        messageSeparator: '',
        roleSeparator: specialTokens_js_1.ImSep,
    },
};
exports.chatModelParams = internalChatModelParams;
//# sourceMappingURL=mapping.js.map