"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertToOpenAITool = exports.convertToOpenAIFunction = void 0;
const zod_to_json_schema_1 = require("zod-to-json-schema");
/**
 * Formats a `StructuredTool` instance into a format that is compatible
 * with OpenAI function calling. It uses the `zodToJsonSchema`
 * function to convert the schema of the `StructuredTool` into a JSON
 * schema, which is then used as the parameters for the OpenAI function.
 */
function convertToOpenAIFunction(tool) {
    return {
        name: tool.name,
        description: tool.description,
        parameters: (0, zod_to_json_schema_1.zodToJsonSchema)(tool.schema),
    };
}
exports.convertToOpenAIFunction = convertToOpenAIFunction;
/**
 * Formats a `StructuredTool` instance into a format that is compatible
 * with OpenAI tool calling. It uses the `zodToJsonSchema`
 * function to convert the schema of the `StructuredTool` into a JSON
 * schema, which is then used as the parameters for the OpenAI tool.
 */
function convertToOpenAITool(tool) {
    return {
        type: "function",
        function: convertToOpenAIFunction(tool),
    };
}
exports.convertToOpenAITool = convertToOpenAITool;
