/* eslint-disable @typescript-eslint/no-explicit-any */
export class MockAsyncLocalStorage {
    getStore() {
        return undefined;
    }
    run(_store, callback) {
        callback();
    }
}
class AsyncLocalStorageProvider {
    constructor() {
        Object.defineProperty(this, "asyncLocalStorage", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new MockAsyncLocalStorage()
        });
        Object.defineProperty(this, "hasBeenInitialized", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
    }
    getInstance() {
        return this.asyncLocalStorage;
    }
    initializeGlobalInstance(instance) {
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            this.asyncLocalStorage = instance;
        }
    }
}
const AsyncLocalStorageProviderSingleton = new AsyncLocalStorageProvider();
export { AsyncLocalStorageProviderSingleton };
