"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionStatusesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _api = require("../../../lib/api");
var _components = require("../../../components");
var _app_context = require("../../../app_context");
var _watch_details_context = require("../watch_details_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionStatusesPanel = () => {
  const {
    toasts
  } = (0, _app_context.useAppContext)();
  const {
    watchDetail
  } = (0, _react.useContext)(_watch_details_context.WatchDetailsContext);
  const [actionStatuses, setActionStatuses] = (0, _react.useState)([]);
  const [isActionStatusLoading, setIsActionStatusLoading] = (0, _react.useState)(false);
  const [selectedErrorAction, setSelectedErrorAction] = (0, _react.useState)(null);
  const {
    id: watchId,
    watchErrors,
    watchStatus,
    isSystemWatch
  } = watchDetail;
  const actionErrors = watchErrors && watchErrors.actionErrors;
  const currentActionStatuses = watchStatus && watchStatus.actionStatuses;
  const hasActionErrors = actionErrors && Object.keys(actionErrors).length > 0;
  (0, _react.useEffect)(() => {
    const actionStatusesWithErrors = currentActionStatuses && currentActionStatuses.map(currentActionStatus => {
      const errors = actionErrors && actionErrors[currentActionStatus.id];
      return {
        ...currentActionStatus,
        errors: errors || []
      };
    });
    setActionStatuses(actionStatusesWithErrors);
  }, [watchDetail, actionErrors, currentActionStatuses]);
  const baseColumns = [{
    field: 'id',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.actionHeader', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: false
  }, {
    field: 'state',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.stateHeader.tooltipText', {
        defaultMessage: 'OK, acknowledged, throttled, or error.'
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.stateHeader', {
      defaultMessage: 'State'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: true,
    render: state => /*#__PURE__*/_react.default.createElement(_components.ActionStateBadge, {
      state: state
    })
  }, {
    field: 'lastExecution',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchActionStatusTable.lastExecuted.tooltipText', {
        defaultMessage: `The last time this action was executed.`
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.watcher.sections.watchHistory.watchActionStatusTable.lastExecuted', {
      defaultMessage: 'Last executed'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignTop"
    }))),
    sortable: true,
    truncateText: false,
    render: lastExecution => {
      var _lastExecution$format;
      return (_lastExecution$format = lastExecution === null || lastExecution === void 0 ? void 0 : lastExecution.format()) !== null && _lastExecution$format !== void 0 ? _lastExecution$format : '';
    }
  }];
  const errorColumn = {
    field: 'errors',
    name: _i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.errorsHeader', {
      defaultMessage: 'Errors'
    }),
    render: (errors, action) => {
      const {
        id: actionId
      } = action;
      if (errors && errors.length > 0) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: () => setSelectedErrorAction(actionId),
          "data-test-subj": "actionErrorsButton"
        }, _i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.errorsCellText', {
          defaultMessage: '{total, number} {total, plural, one {error} other {errors}}',
          values: {
            total: errors.length
          }
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null);
    }
  };
  const actionColumn = {
    actions: [{
      available: action => action.isAckable && !isSystemWatch,
      render: action => {
        const {
          id: actionId
        } = action;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.ackActionCellTooltipTitle', {
            defaultMessage: 'Acknowledge watch action.'
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          iconType: "check",
          isLoading: isActionStatusLoading,
          "data-test-subj": "acknowledgeWatchButton",
          onClick: async () => {
            setIsActionStatusLoading(true);
            try {
              const newWatchStatus = await (0, _api.ackWatchAction)(watchId, actionId);
              const newActionStatusesWithErrors = newWatchStatus.actionStatuses.map(newActionStatus => {
                const errors = actionErrors && actionErrors[newActionStatus.id];
                return {
                  ...newActionStatus,
                  errors: errors || []
                };
              });
              setIsActionStatusLoading(false);
              return setActionStatuses(newActionStatusesWithErrors);
            } catch (e) {
              setIsActionStatusLoading(false);
              toasts.addDanger(_i18n.i18n.translate('xpack.watcher.sections.watchDetail.watchTable.ackActionErrorMessage', {
                defaultMessage: 'Error acknowledging action {actionId}',
                values: {
                  actionId: action.id
                }
              }));
            }
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.watcher.sections.watchDetail.watchTable.ackActionCellTitle",
          defaultMessage: "Acknowledge"
        })));
      }
    }]
  };
  const columns = hasActionErrors ? [...baseColumns, errorColumn, actionColumn] : [...baseColumns, actionColumn];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "watchDetailSection"
  }, selectedErrorAction && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "s",
    "aria-labelledby": "flyoutActionErrorTitle",
    "data-test-subj": "actionErrorsFlyout",
    onClose: () => setSelectedErrorAction(null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutActionErrorTitle",
    "data-test-subj": "title"
  }, selectedErrorAction))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.watcher.sections.watchDetail.actionErrorsCalloutTitle', {
      defaultMessage: 'This action contains errors'
    }),
    color: "danger",
    iconType: "cross",
    "data-test-subj": "errorMessage"
  }, actionErrors[selectedErrorAction].length > 1 ? /*#__PURE__*/_react.default.createElement("ul", null, actionErrors[selectedErrorAction].map((actionError, errorIndex) => /*#__PURE__*/_react.default.createElement("li", {
    key: `action-error-${errorIndex}`
  }, actionError.message))) : /*#__PURE__*/_react.default.createElement("p", null, actionErrors[selectedErrorAction][0].message)))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: actionStatuses,
    itemId: "id",
    columns: columns,
    pagination: _constants.PAGINATION,
    sorting: true,
    "data-test-subj": "watchActionStatusTable",
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.watcher.sections.watchDetail.watchTable.noWatchesMessage",
      defaultMessage: "No actions to show"
    })
  }));
};
exports.ActionStatusesPanel = ActionStatusesPanel;