"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showNewVisModal = showNewVisModal;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const NewVisModal = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./new_vis_modal'))));
/**
 * shows modal dialog that allows you to create new visualization
 * @param {string[]} editorParams
 * @param {function} onClose - function that will be called when dialog is closed
 */
function showNewVisModal({
  editorParams = [],
  onClose,
  originatingApp,
  outsideVisualizeApp,
  showAggsSelection,
  selectedVisType
} = {}) {
  const container = document.createElement('div');
  let isClosed = false;
  const handleClose = () => {
    if (isClosed) return;
    _reactDom.default.unmountComponentAtNode(container);
    document.body.removeChild(container);
    if (onClose) {
      onClose();
    }
    isClosed = true;
  };
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: (0, _services.getTheme)().theme$
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      position: "fixed"
    }))
  }, /*#__PURE__*/_react.default.createElement(NewVisModal, {
    isOpen: true,
    onClose: handleClose,
    originatingApp: originatingApp,
    stateTransfer: (0, _services.getEmbeddable)().getStateTransfer(),
    outsideVisualizeApp: outsideVisualizeApp,
    editorParams: editorParams,
    visTypesRegistry: (0, _services.getTypes)(),
    contentClient: (0, _services.getContentManagement)().client,
    uiSettings: (0, _services.getUISettings)(),
    addBasePath: (0, _services.getHttp)().basePath.prepend,
    application: (0, _services.getApplication)(),
    docLinks: (0, _services.getDocLinks)(),
    showAggsSelection: showAggsSelection,
    selectedVisType: selectedVisType
  }))));
  _reactDom.default.render(element, container);
  return () => handleClose();
}