"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSelection = GroupSelection;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _vis_groups_enum = require("../../vis_types/vis_groups_enum");
require("./group_selection.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function GroupSelection(props) {
  const visualizeGuideLink = props.docLinks.links.dashboard.guide;
  const promotedVisGroups = (0, _react.useMemo)(() => (0, _lodash.orderBy)([...props.visTypesRegistry.getAliases(), ...props.visTypesRegistry.getByGroup(_vis_groups_enum.VisGroups.PROMOTED)].filter(visDefinition => {
    return !visDefinition.disableCreate;
  }), ['promotion', 'title'], ['asc', 'asc']), [props.visTypesRegistry]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "groupModalHeader"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.title",
    defaultMessage: "New visualization"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    className: "visNewVisDialogGroupSelection__body"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "visNewVisDialogGroupSelection__visGroups"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    "data-test-subj": "visNewDialogGroups"
  }, promotedVisGroups.map(visType => /*#__PURE__*/_react.default.createElement(VisGroup, {
    visType: visType,
    key: visType.name,
    onVisTypeSelected: props.onVisTypeSelected
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "visNewVisDialogGroupSelection__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2
  }, props.visTypesRegistry.getByGroup(_vis_groups_enum.VisGroups.AGGBASED).filter(visDefinition => {
    return !visDefinition.disableCreate;
  }).length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    titleSize: "xs",
    layout: "horizontal",
    display: "transparent",
    onClick: () => props.toggleGroups(false),
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "visGroupAggBasedTitle"
    }, _i18n.i18n.translate('visualizations.newVisWizard.aggBasedGroupTitle', {
      defaultMessage: 'Aggregation based'
    })),
    "data-test-subj": "visGroup-aggbased",
    description: _i18n.i18n.translate('visualizations.newVisWizard.aggBasedGroupDescription', {
      defaultMessage: 'Use our classic visualize library to create charts based on aggregations.'
    }),
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "heatmap",
      size: "xl",
      color: "success"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "visGroupAggBasedExploreLink",
    onClick: () => props.toggleGroups(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('visualizations.newVisWizard.exploreOptionLinkText', {
    defaultMessage: 'Explore options'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight"
  }))))), props.visTypesRegistry.getByGroup(_vis_groups_enum.VisGroups.TOOLS).length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "visNewVisDialog__toolsCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "visGroup-tools"
  }, _i18n.i18n.translate('visualizations.newVisWizard.toolsGroupTitle', {
    defaultMessage: 'Tools'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "visNewVisDialog__toolsCardGroupContainer"
  }, props.visTypesRegistry.getByGroup(_vis_groups_enum.VisGroups.TOOLS).map(visType => /*#__PURE__*/_react.default.createElement(ToolsGroup, {
    visType: visType,
    key: visType.name,
    onVisTypeSelected: props.onVisTypeSelected,
    showExperimental: props.showExperimental
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "visNewVisDialogGroupSelection__footerDescriptionList",
    type: "responsiveColumn"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "visNewVisDialogGroupSelection__footerDescriptionListTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.learnMoreText",
    defaultMessage: "Want to learn more?"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: visualizeGuideLink,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.readDocumentationLink",
    defaultMessage: "Read documentation"
  })))))));
}
const VisGroup = ({
  visType,
  onVisTypeSelected
}) => {
  const onClick = (0, _react.useCallback)(() => {
    onVisTypeSelected(visType);
  }, [onVisTypeSelected, visType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "visNewVisDialog__groupsCardWrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    titleSize: "xs",
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "visTypeTitle"
    }, 'titleInWizard' in visType && visType.titleInWizard ? visType.titleInWizard : visType.title),
    onClick: onClick,
    "data-test-subj": `visType-${visType.name}`,
    "data-vis-stage": !('alias' in visType) ? visType.stage : 'alias',
    "aria-label": `visType-${visType.name}`,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, visType.description || ''), /*#__PURE__*/_react.default.createElement("em", null, " ", visType.note || '')),
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: visType.icon || 'empty',
      size: "xl",
      color: "success"
    })
  }));
};
const ToolsGroup = ({
  visType,
  onVisTypeSelected,
  showExperimental
}) => {
  const onClick = (0, _react.useCallback)(() => {
    onVisTypeSelected(visType);
  }, [onVisTypeSelected, visType]);
  // hide both the hidden visualizations and, if lab mode is not enabled, the experimental visualizations
  // TODO: Remove the showExperimental logic as part of https://github.com/elastic/kibana/issues/152833
  if (visType.disableCreate || !showExperimental && visType.stage === 'experimental') {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: visType.icon || 'empty',
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `visType-${visType.name}`,
    "data-vis-stage": visType.stage,
    onClick: onClick
  }, 'titleInWizard' in visType && visType.titleInWizard ? visType.titleInWizard : visType.title)), visType.stage === 'experimental' && !visType.isDeprecated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    iconType: "beaker",
    tooltipContent: _i18n.i18n.translate('visualizations.newVisWizard.experimentalTooltip', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    label: _i18n.i18n.translate('visualizations.newVisWizard.experimentalTitle', {
      defaultMessage: 'Technical preview'
    })
  })) : visType.isDeprecated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.deprecatedTag",
    defaultMessage: "Deprecated"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, visType.description)));
};