"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSplitChart = exports.CHARTS_WITHOUT_SMALL_MULTIPLES = exports.CHARTS_TO_BE_DEPRECATED = exports.CHARTS_CONFIG_TOKENS = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CHARTS_WITHOUT_SMALL_MULTIPLES = exports.CHARTS_WITHOUT_SMALL_MULTIPLES = {
  gauge: 'gauge'
};
const CHARTS_TO_BE_DEPRECATED = exports.CHARTS_TO_BE_DEPRECATED = {
  pie: 'pie',
  controls: 'input_control_vis'
};
const CHARTS_CONFIG_TOKENS = exports.CHARTS_CONFIG_TOKENS = {
  [CHARTS_WITHOUT_SMALL_MULTIPLES.gauge]: _constants.NEW_GAUGE_CHARTS_LIBRARY
};
const isSplitChart = (chartType, aggs) => {
  var _knownCheckers;
  const defaultIsSplitChart = () => aggs === null || aggs === void 0 ? void 0 : aggs.aggs.some(agg => agg.schema === 'split');
  const knownCheckers = {
    [CHARTS_WITHOUT_SMALL_MULTIPLES.gauge]: () => aggs === null || aggs === void 0 ? void 0 : aggs.aggs.some(agg => agg.schema === 'group')
  };
  return ((_knownCheckers = knownCheckers[chartType]) !== null && _knownCheckers !== void 0 ? _knownCheckers : defaultIsSplitChart)();
};
exports.isSplitChart = isSplitChart;