"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisualizeListItemLink = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _services = require("../../services");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getVisualizeListItemLink = (application, kbnUrlStateStorage, editApp, editUrl, error = undefined) => {
  if (error || !editApp && !editUrl) {
    return undefined;
  }

  // for visualizations the editApp is undefined
  let url = application.getUrlForApp(editApp !== null && editApp !== void 0 ? editApp : _constants.VISUALIZE_APP_NAME, {
    path: editApp ? editUrl : `#${editUrl}`
  });
  const useHash = (0, _services.getUISettings)().get('state:storeInSessionStorage');
  const globalStateInUrl = kbnUrlStateStorage.get(_constants.GLOBAL_STATE_STORAGE_KEY) || {};
  url = (0, _public.setStateToKbnUrl)(_constants.GLOBAL_STATE_STORAGE_KEY, globalStateInUrl, {
    useHash
  }, url);
  return url;
};
exports.getVisualizeListItemLink = getVisualizeListItemLink;