"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _history = require("history");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _public3 = require("@kbn/embeddable-plugin/public");
var _triggers = require("./triggers");
var _vis_editors_registry = require("./vis_editors_registry");
var _wizard = require("./wizard");
var _locator = require("../common/locator");
var _xy_dimension = require("../common/expression_functions/xy_dimension");
var _vis_dimension = require("../common/expression_functions/vis_dimension");
var _range = require("../common/expression_functions/range");
var _types_service = require("./vis_types/types_service");
var _embeddable = require("./embeddable");
var _services = require("./services");
var _constants = require("../common/constants");
var _edit_in_lens_action = require("./actions/edit_in_lens_action");
var _content_management = require("../common/content_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Interface for this plugin's returned setup/start contracts.
 *
 * @public
 */

/**
 * Visualizations Plugin - public
 *
 * This plugin's stateful contracts are returned from the `setup` and `start` methods
 * below. The interfaces for these contracts are provided above.
 *
 * @internal
 */
class VisualizationsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "types", new _types_service.TypesService());
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "stopUrlTracking", undefined);
    (0, _defineProperty2.default)(this, "currentHistory", undefined);
    (0, _defineProperty2.default)(this, "isLinkedToOriginatingApp", undefined);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    embeddable,
    data,
    home,
    urlForwarding,
    share,
    uiActions,
    contentManagement
  }) {
    const {
      appMounted,
      appUnMounted,
      stop: stopUrlTracker,
      setActiveUrl,
      restorePreviousUrl
    } = (0, _public2.createKbnUrlTracker)({
      baseUrl: core.http.basePath.prepend(_constants.VisualizeConstants.VISUALIZE_BASE_PATH),
      defaultSubUrl: '#/',
      storageKey: `lastUrl:${core.http.basePath.get()}:visualize`,
      navLinkUpdater$: this.appStateUpdater,
      toastNotifications: core.notifications.toasts,
      stateParams: [{
        kbnUrlKey: '_g',
        stateUpdate$: data.query.state$.pipe((0, _rxjs.filter)(({
          changes
        }) => !!(changes.globalFilters || changes.time || changes.refreshInterval)), (0, _rxjs.map)(({
          state
        }) => ({
          ...state,
          filters: data.query.filterManager.getGlobalFilters()
        })))
      }],
      getHistory: () => this.currentHistory,
      onBeforeNavLinkSaved: urlToSave => {
        var _this$isLinkedToOrigi;
        if ((_this$isLinkedToOrigi = this.isLinkedToOriginatingApp) !== null && _this$isLinkedToOrigi !== void 0 && _this$isLinkedToOrigi.call(this)) {
          return core.http.basePath.prepend(_constants.VisualizeConstants.VISUALIZE_BASE_PATH);
        }
        const tableListUrlState = ['s', 'title', 'sort', 'sortdir'];
        return (0, _common.replaceUrlHashQuery)(urlToSave, query => {
          tableListUrlState.forEach(param => {
            delete query[param];
          });
          return query;
        });
      }
    });
    this.stopUrlTracking = () => {
      stopUrlTracker();
    };
    const start = (0, _public2.createStartServicesGetter)(core.getStartServices);
    const listingViewRegistry = new Set();
    const visEditorsRegistry = (0, _vis_editors_registry.createVisEditorsRegistry)();
    core.application.register({
      id: _constants.VisualizeConstants.APP_ID,
      title: 'Visualize Library',
      order: 8000,
      euiIconType: 'logoKibana',
      defaultPath: '#/',
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      updater$: this.appStateUpdater.asObservable(),
      // remove all references to visualize
      mount: async params => {
        var _pluginsStart$savedOb;
        const [coreStart, pluginsStart] = await core.getStartServices();
        this.currentHistory = params.history;

        // allows the urlTracker to only save URLs that are not linked to an originatingApp
        this.isLinkedToOriginatingApp = () => {
          var _pluginsStart$embedda;
          return Boolean((_pluginsStart$embedda = pluginsStart.embeddable.getStateTransfer().getIncomingEditorState(_constants.VisualizeConstants.APP_ID)) === null || _pluginsStart$embedda === void 0 ? void 0 : _pluginsStart$embedda.originatingApp);
        };

        // make sure the index pattern list is up to date
        pluginsStart.dataViews.clearCache();
        appMounted();

        // dispatch synthetic hash change event to update hash history objects
        // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
        const unlistenParentHistory = params.history.listen(() => {
          window.dispatchEvent(new HashChangeEvent('hashchange'));
        });
        /**
         * current implementation uses 2 history objects:
         * 1. the hash history (used for the react hash router)
         * 2. and the scoped history (used for url tracking)
         * this should be replaced to use only scoped history after moving legacy apps to browser routing
         */
        const history = (0, _history.createHashHistory)();
        const services = {
          ...coreStart,
          history,
          kbnUrlStateStorage: (0, _public2.createKbnUrlStateStorage)({
            history,
            useHash: coreStart.uiSettings.get('state:storeInSessionStorage'),
            ...(0, _public2.withNotifyOnErrors)(coreStart.notifications.toasts)
          }),
          urlForwarding: pluginsStart.urlForwarding,
          pluginInitializerContext: this.initializerContext,
          chrome: coreStart.chrome,
          data: pluginsStart.data,
          core: coreStart,
          dataViewEditor: pluginsStart.dataViewEditor,
          dataViews: pluginsStart.dataViews,
          localStorage: new _public2.Storage(localStorage),
          navigation: pluginsStart.navigation,
          share: pluginsStart.share,
          toastNotifications: coreStart.notifications.toasts,
          visualizeCapabilities: coreStart.application.capabilities.visualize,
          dashboardCapabilities: coreStart.application.capabilities.dashboard,
          embeddable: pluginsStart.embeddable,
          stateTransferService: pluginsStart.embeddable.getStateTransfer(),
          setActiveUrl,
          createVisEmbeddableFromObject: (0, _embeddable.createVisEmbeddableFromObject)({
            start
          }),
          scopedHistory: params.history,
          restorePreviousUrl,
          setHeaderActionMenu: params.setHeaderActionMenu,
          savedObjectsTagging: (_pluginsStart$savedOb = pluginsStart.savedObjectsTaggingOss) === null || _pluginsStart$savedOb === void 0 ? void 0 : _pluginsStart$savedOb.getTaggingApi(),
          savedSearch: pluginsStart.savedSearch,
          presentationUtil: pluginsStart.presentationUtil,
          getKibanaVersion: () => this.initializerContext.env.packageInfo.version,
          spaces: pluginsStart.spaces,
          visEditorsRegistry,
          listingViewRegistry,
          unifiedSearch: pluginsStart.unifiedSearch,
          serverless: pluginsStart.serverless,
          noDataPage: pluginsStart.noDataPage,
          contentManagement: pluginsStart.contentManagement
        };
        params.element.classList.add('visAppWrapper');
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./visualize_app')));
        if (pluginsStart.screenshotMode.isScreenshotMode()) {
          params.element.classList.add('visEditorScreenshotModeActive');
          // @ts-expect-error TS error, cannot find type declaration for scss
          await Promise.resolve().then(() => _interopRequireWildcard(require('./visualize_screenshot_mode.scss')));
        }
        const unmount = renderApp(params, services);
        return () => {
          data.search.session.clear();
          params.element.classList.remove('visAppWrapper');
          unlistenParentHistory();
          unmount();
          appUnMounted();
        };
      }
    });
    urlForwarding.forwardApp('visualize', 'visualize');
    if (home) {
      home.featureCatalogue.register({
        id: 'visualize',
        title: 'Visualize Library',
        description: _i18n.i18n.translate('visualizations.visualizeDescription', {
          defaultMessage: 'Create visualizations and aggregate data stores in your Elasticsearch indices.'
        }),
        icon: 'visualizeApp',
        path: `/app/visualize#${_constants.VisualizeConstants.LANDING_PAGE_PATH}`,
        showOnHomePage: false,
        category: 'data'
      });
    }
    if (share) {
      share.url.locators.create(new _locator.VisualizeLocatorDefinition());
    }
    (0, _services.setUISettings)(core.uiSettings);
    (0, _services.setTheme)(core.theme);
    expressions.registerFunction(_range.range);
    expressions.registerFunction(_vis_dimension.visDimension);
    expressions.registerFunction(_xy_dimension.xyDimension);
    uiActions.registerTrigger(_triggers.aggBasedVisualizationTrigger);
    uiActions.registerTrigger(_triggers.visualizeEditorTrigger);
    uiActions.registerTrigger(_triggers.dashboardVisualizationPanelTrigger);
    const editInLensAction = new _edit_in_lens_action.EditInLensAction(data.query.timefilter.timefilter);
    uiActions.addTriggerAction('CONTEXT_MENU_TRIGGER', editInLensAction);
    const embeddableFactory = new _embeddable.VisualizeEmbeddableFactory({
      start
    });
    embeddable.registerEmbeddableFactory(_embeddable.VISUALIZE_EMBEDDABLE_TYPE, embeddableFactory);
    contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: 'Visualize Library'
    });
    (0, _public3.registerSavedObjectToPanelMethod)(_content_management.CONTENT_ID, savedObject => {
      const visState = savedObject.attributes.visState;

      // not sure if visState actually is ever undefined, but following the type
      if (!savedObject.managed || !visState) {
        return {
          savedObjectId: savedObject.id
        };
      }

      // data is not always defined, so I added a default value since the extract
      // routine in the embeddable factory expects it to be there
      const savedVis = JSON.parse(visState);
      if (!savedVis.data) {
        savedVis.data = {
          searchSource: {},
          aggs: []
        };
      }
      return {
        savedVis: savedVis // now we're sure we have "data" prop
      };
    });
    return {
      ...this.types.setup(),
      visEditorsRegistry,
      listingViewRegistry
    };
  }
  start(core, {
    data,
    expressions,
    uiActions,
    embeddable,
    savedObjects,
    spaces,
    savedObjectsTaggingOss,
    fieldFormats,
    usageCollection,
    savedObjectsManagement,
    contentManagement,
    savedSearch
  }) {
    const types = this.types.start();
    (0, _services.setTypes)(types);
    (0, _services.setEmbeddable)(embeddable);
    (0, _services.setApplication)(core.application);
    (0, _services.setCapabilities)(core.application.capabilities);
    (0, _services.setHttp)(core.http);
    (0, _services.setSavedObjects)(core.savedObjects);
    (0, _services.setDocLinks)(core.docLinks);
    (0, _services.setSearch)(data.search);
    (0, _services.setExpressions)(expressions);
    (0, _services.setUiActions)(uiActions);
    (0, _services.setTimeFilter)(data.query.timefilter.timefilter);
    (0, _services.setAggs)(data.search.aggs);
    (0, _services.setOverlays)(core.overlays);
    (0, _services.setExecutionContext)(core.executionContext);
    (0, _services.setChrome)(core.chrome);
    (0, _services.setFieldFormats)(fieldFormats);
    (0, _services.setUsageCollection)(usageCollection);
    (0, _services.setSavedObjectsManagement)(savedObjectsManagement);
    (0, _services.setContentManagement)(contentManagement);
    (0, _services.setSavedSearch)(savedSearch);
    if (spaces) {
      (0, _services.setSpaces)(spaces);
    }
    if (savedObjectsTaggingOss) {
      (0, _services.setSavedObjectTagging)(savedObjectsTaggingOss);
    }
    return {
      ...types,
      showNewVisModal: _wizard.showNewVisModal
    };
  }
  stop() {
    this.types.stop();
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
}
exports.VisualizationsPlugin = VisualizationsPlugin;