"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiHasVisualizeConfig = void 0;
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const apiHasVisualizeConfig = api => {
  return Boolean(api && (0, _presentationPublishing.apiIsOfType)(api, 'visualization') && typeof api.getVis === 'function');
};
exports.apiHasVisualizeConfig = apiHasVisualizeConfig;