"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditInLensAction = exports.ACTION_EDIT_IN_LENS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _embeddable = require("../embeddable");
var _has_expression_variables = require("../embeddable/interfaces/has_expression_variables");
var _services = require("../services");
var _triggers = require("../triggers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EDIT_IN_LENS = exports.ACTION_EDIT_IN_LENS = 'ACTION_EDIT_IN_LENS';
const displayName = _i18n.i18n.translate('visualizations.actions.editInLens.displayName', {
  defaultMessage: 'Convert to Lens'
});
const MenuItem = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, displayName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'accent'
  }, _i18n.i18n.translate('visualizations.tonNavMenu.tryItBadgeText', {
    defaultMessage: 'Try it'
  }))));
};
const compatibilityCheck = api => (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _embeddable.apiHasVisualizeConfig)(api);
class EditInLensAction {
  constructor(timefilter) {
    (0, _defineProperty2.default)(this, "id", ACTION_EDIT_IN_LENS);
    (0, _defineProperty2.default)(this, "type", ACTION_EDIT_IN_LENS);
    (0, _defineProperty2.default)(this, "order", 49);
    (0, _defineProperty2.default)(this, "showNotification", true);
    (0, _defineProperty2.default)(this, "currentAppId", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", MenuItem);
    this.timefilter = timefilter;
  }
  async execute(context) {
    var _vis$type$navigateToL, _vis$type, _vis$data$searchSourc, _vis$data$searchSourc2, _vis$data$searchSourc3, _parentSearchSource$g, _parentSearchSource$g2, _embeddable$panelTitl, _embeddable$timeRange, _embeddable$panelDesc;
    const application = (0, _services.getApplication)();
    if (application !== null && application !== void 0 && application.currentAppId$) {
      application.currentAppId$.pipe((0, _rxjs.take)(1)).subscribe(appId => this.currentAppId = appId);
      application.currentAppId$.subscribe(() => {
        (0, _services.getEmbeddable)().getStateTransfer().isTransferInProgress = false;
      });
    }
    const {
      embeddable
    } = context;
    if (!compatibilityCheck(embeddable)) return;
    const vis = embeddable.getVis();
    const navigateToLensConfig = await ((_vis$type$navigateToL = (_vis$type = vis.type).navigateToLens) === null || _vis$type$navigateToL === void 0 ? void 0 : _vis$type$navigateToL.call(_vis$type, vis, this.timefilter));
    // Filters and query set on the visualization level
    const visFilters = (_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.getField('filter');
    const visQuery = (_vis$data$searchSourc2 = vis.data.searchSource) === null || _vis$data$searchSourc2 === void 0 ? void 0 : _vis$data$searchSourc2.getField('query');
    const parentSearchSource = (_vis$data$searchSourc3 = vis.data.searchSource) === null || _vis$data$searchSourc3 === void 0 ? void 0 : _vis$data$searchSourc3.getParent();
    const searchFilters = (_parentSearchSource$g = parentSearchSource === null || parentSearchSource === void 0 ? void 0 : parentSearchSource.getField('filter')) !== null && _parentSearchSource$g !== void 0 ? _parentSearchSource$g : visFilters;
    const searchQuery = (_parentSearchSource$g2 = parentSearchSource === null || parentSearchSource === void 0 ? void 0 : parentSearchSource.getField('query')) !== null && _parentSearchSource$g2 !== void 0 ? _parentSearchSource$g2 : visQuery;
    const title = vis.title || ((_embeddable$panelTitl = embeddable.panelTitle) === null || _embeddable$panelTitl === void 0 ? void 0 : _embeddable$panelTitl.getValue());
    const panelTimeRange = (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.getValue();
    const updatedWithMeta = {
      ...navigateToLensConfig,
      title,
      visTypeTitle: vis.type.title,
      embeddableId: embeddable.uuid,
      originatingApp: this.currentAppId,
      searchFilters,
      searchQuery,
      isEmbeddable: true,
      description: vis.description || ((_embeddable$panelDesc = embeddable.panelDescription) === null || _embeddable$panelDesc === void 0 ? void 0 : _embeddable$panelDesc.getValue()),
      panelTimeRange
    };
    if (navigateToLensConfig) {
      if (this.currentAppId) {
        (0, _services.getUsageCollection)().reportUiCounter(this.currentAppId, _analytics.METRIC_TYPE.CLICK, ACTION_EDIT_IN_LENS);
      }
      (0, _services.getEmbeddable)().getStateTransfer().isTransferInProgress = true;
      (0, _services.getUiActions)().getTrigger(_triggers.DASHBOARD_VISUALIZATION_PANEL_TRIGGER).exec(updatedWithMeta);
    }
  }
  getDisplayName() {
    return displayName;
  }
  getIconType() {
    return 'merge';
  }
  async isCompatible(context) {
    var _embeddable$getExpres, _vis$type$navigateToL2, _vis$type2;
    const {
      embeddable
    } = context;
    if (!compatibilityCheck(embeddable) || (0, _presentationPublishing.getInheritedViewMode)(embeddable) !== _public.ViewMode.EDIT) return false;
    const vis = embeddable.getVis();
    const {
      visualize
    } = (0, _services.getCapabilities)();
    if (!vis || !visualize.show) {
      return false;
    }

    // determine whether navigation to lens is available
    if ((0, _has_expression_variables.apiHasExpressionVariables)(embeddable) && (_embeddable$getExpres = embeddable.getExpressionVariables()) !== null && _embeddable$getExpres !== void 0 && _embeddable$getExpres.canNavigateToLens) {
      return true;
    }
    return Boolean(await ((_vis$type$navigateToL2 = (_vis$type2 = vis.type).navigateToLens) === null || _vis$type$navigateToL2 === void 0 ? void 0 : _vis$type$navigateToL2.call(_vis$type2, vis, this.timefilter)));
  }
}
exports.EditInLensAction = EditInLensAction;