"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.touchdownTemplate = void 0;
var _react = _interopRequireDefault(require("react"));
var _server = _interopRequireDefault(require("react-dom/server"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const touchdownTemplate = ({
  wholeBucket
}) => {
  return _server.default.renderToStaticMarkup( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: (0, _services.getTheme)().theme$
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "visTooltip__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "iInCircle",
    className: "visTooltip__headerIcon"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "visTooltip__headerText"
  }, wholeBucket ? 'Part of this bucket' : 'This area', " may contain partial data. The selected time range does not fully cover it."))));
};
exports.touchdownTemplate = touchdownTemplate;