"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisLegend = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _std = require("@kbn/std");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _models = require("./models");
var _legend_item = require("./legend_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class VisLegend extends _react.PureComponent {
  constructor(props) {
    var _props$addLegend, _props$uiState;
    super(props);

    // TODO: Check when this bwc can safely be removed
    (0, _defineProperty2.default)(this, "legendId", (0, _eui.htmlIdGenerator)()('legend'));
    (0, _defineProperty2.default)(this, "getColor", () => '');
    (0, _defineProperty2.default)(this, "toggleLegend", () => {
      const newOpen = !this.state.open;
      this.setState({
        open: newOpen
      }, () => {
        var _this$props$uiState;
        (_this$props$uiState = this.props.uiState) === null || _this$props$uiState === void 0 ? void 0 : _this$props$uiState.set('vis.legendOpen', newOpen);
      });
    });
    (0, _defineProperty2.default)(this, "setColor", (label, color, event) => {
      if (event.key && event.key !== _eui.keys.ENTER) {
        return;
      }
      this.setState({
        selectedLabel: null
      }, () => {
        var _this$props$uiState2, _this$props$uiState3, _this$props$uiState4, _this$props$uiState5;
        const colors = ((_this$props$uiState2 = this.props.uiState) === null || _this$props$uiState2 === void 0 ? void 0 : _this$props$uiState2.get('vis.colors')) || {};
        if (colors[label] === color || !color) delete colors[label];else colors[label] = color;
        (_this$props$uiState3 = this.props.uiState) === null || _this$props$uiState3 === void 0 ? void 0 : _this$props$uiState3.setSilent('vis.colors', null);
        (_this$props$uiState4 = this.props.uiState) === null || _this$props$uiState4 === void 0 ? void 0 : _this$props$uiState4.set('vis.colors', colors);
        (_this$props$uiState5 = this.props.uiState) === null || _this$props$uiState5 === void 0 ? void 0 : _this$props$uiState5.emit('colorChanged');
        this.refresh();
      });
    });
    (0, _defineProperty2.default)(this, "filter", ({
      values: data
    }, negate) => {
      this.props.fireEvent({
        name: 'filter',
        data: {
          data,
          negate
        }
      });
    });
    (0, _defineProperty2.default)(this, "canFilter", async item => {
      if (_models.CUSTOM_LEGEND_VIS_TYPES.includes(this.props.vislibVis.visConfigArgs.type)) {
        return false;
      }
      if (item.values && (0, _lodash.every)(item.values, _lodash.isUndefined)) {
        return false;
      }
      const filters = await (0, _services.getDataActions)().createFiltersFromValueClickAction({
        data: item.values
      });
      return Boolean(filters.length);
    });
    (0, _defineProperty2.default)(this, "toggleDetails", label => event => {
      if (event && event.key && event.key !== _eui.keys.ENTER) {
        return;
      }
      this.setState({
        selectedLabel: this.state.selectedLabel === label ? null : label
      });
    });
    (0, _defineProperty2.default)(this, "getSeriesLabels", data => {
      const values = data.map(chart => chart.series).reduce((a, b) => a.concat(b), []);
      return (0, _lodash.compact)((0, _lodash.uniqBy)(values, 'label')).map(label => ({
        ...label,
        values: [label.values[0].seriesRaw]
      }));
    });
    (0, _defineProperty2.default)(this, "setFilterableLabels", items => new Promise(async (resolve, reject) => {
      try {
        const filterableLabels = new Set();
        await (0, _std.asyncForEach)(items, async item => {
          const canFilter = await this.canFilter(item);
          if (canFilter) {
            filterableLabels.add(item.label);
          }
        });
        this.setState({
          filterableLabels
        }, resolve);
      } catch (error) {
        reject(error);
      }
    }));
    (0, _defineProperty2.default)(this, "setLabels", (data, type) => {
      let labels = [];
      if (_models.CUSTOM_LEGEND_VIS_TYPES.includes(type)) {
        const legendLabels = this.props.vislibVis.getLegendLabels();
        if (legendLabels) {
          labels = (0, _lodash.map)(legendLabels, label => {
            return {
              label
            };
          });
        }
      } else {
        if (!data) return [];
        data = data.columns || data.rows || [data];
        labels = this.getSeriesLabels(data);
      }
      this.setFilterableLabels(labels);
      this.setState({
        labels
      });
    });
    (0, _defineProperty2.default)(this, "refresh", () => {
      var _this$props$uiState6;
      const vislibVis = this.props.vislibVis;
      if (!vislibVis || !vislibVis.visConfig) {
        this.setState({
          labels: [{
            label: _i18n.i18n.translate('visTypeVislib.vislib.legend.loadingLabel', {
              defaultMessage: 'loading…'
            })
          }]
        });
        return;
      } // make sure vislib is defined at this point

      if (((_this$props$uiState6 = this.props.uiState) === null || _this$props$uiState6 === void 0 ? void 0 : _this$props$uiState6.get('vis.legendOpen')) == null && this.props.addLegend != null) {
        this.setState({
          open: this.props.addLegend
        });
      }
      if (vislibVis.visConfig) {
        this.getColor = this.props.vislibVis.visConfig.data.getColorFunc();
      }
      this.setLabels(this.props.visData, vislibVis.visConfigArgs.type);
    });
    (0, _defineProperty2.default)(this, "highlight", event => {
      const el = event.currentTarget;
      const handler = this.props.vislibVis && this.props.vislibVis.handler;

      // there is no guarantee that a Chart will set the highlight-function on its handler
      if (!handler || typeof handler.highlight !== 'function') {
        return;
      }
      handler.highlight.call(el, handler.el);
    });
    (0, _defineProperty2.default)(this, "unhighlight", event => {
      const el = event.currentTarget;
      const handler = this.props.vislibVis && this.props.vislibVis.handler;

      // there is no guarantee that a Chart will set the unhighlight-function on its handler
      if (!handler || typeof handler.unHighlight !== 'function') {
        return;
      }
      handler.unHighlight.call(el, handler.el);
    });
    (0, _defineProperty2.default)(this, "getAnchorPosition", () => {
      const {
        position
      } = this.props;
      switch (position) {
        case 'bottom':
          return 'upCenter';
        case 'left':
          return 'rightUp';
        case 'right':
          return 'leftUp';
        default:
          return 'downCenter';
      }
    });
    (0, _defineProperty2.default)(this, "renderLegend", anchorPosition => /*#__PURE__*/_react.default.createElement("ul", {
      className: "visLegend__list",
      id: this.legendId
    }, this.state.labels.map(item => /*#__PURE__*/_react.default.createElement(_legend_item.VisLegendItem, {
      item: item,
      key: item.label,
      anchorPosition: anchorPosition,
      selected: this.state.selectedLabel === item.label,
      canFilter: this.state.filterableLabels.has(item.label),
      onFilter: this.filter,
      onSelect: this.toggleDetails,
      setColor: this.setColor,
      getColor: this.getColor,
      onHighlight: this.highlight,
      onUnhighlight: this.unhighlight
    }))));
    const bwcLegendStateDefault = (_props$addLegend = props.addLegend) !== null && _props$addLegend !== void 0 ? _props$addLegend : true;
    const open = (_props$uiState = props.uiState) === null || _props$uiState === void 0 ? void 0 : _props$uiState.get('vis.legendOpen', bwcLegendStateDefault);
    this.state = {
      open,
      labels: [],
      filterableLabels: new Set(),
      selectedLabel: null
    };
  }
  componentDidMount() {
    this.refresh();
  }
  render() {
    const {
      open
    } = this.state;
    const anchorPosition = this.getAnchorPosition();
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "visLegend"
    }, /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      onClick: this.toggleLegend,
      className: (0, _classnames.default)('visLegend__toggle kbn-resetFocusState', {
        'visLegend__toggle--isOpen': open
      }),
      "aria-label": _i18n.i18n.translate('visTypeVislib.vislib.legend.toggleLegendButtonAriaLabel', {
        defaultMessage: 'Toggle legend'
      }),
      "aria-expanded": Boolean(open),
      "aria-controls": this.legendId,
      "data-test-subj": "vislibToggleLegend",
      title: _i18n.i18n.translate('visTypeVislib.vislib.legend.toggleLegendButtonTitle', {
        defaultMessage: 'Toggle legend'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "text",
      type: "list"
    })), open && this.renderLegend(anchorPosition));
  }
}
exports.VisLegend = VisLegend;