"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaVisualization = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _services = require("./services");
var _vega_state_restorer = require("./lib/vega_state_restorer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const createVegaVisualization = ({
  core,
  getServiceSettings
}, renderMode) => class VegaVisualization {
  constructor(el, fireEvent) {
    (0, _defineProperty2.default)(this, "dataPlugin", (0, _services.getData)());
    (0, _defineProperty2.default)(this, "vegaView", null);
    (0, _defineProperty2.default)(this, "vegaStateRestorer", (0, _vega_state_restorer.createVegaStateRestorer)({
      isActive: () => {
        var _this$vegaView, _this$vegaView$_parse;
        return Boolean((_this$vegaView = this.vegaView) === null || _this$vegaView === void 0 ? void 0 : (_this$vegaView$_parse = _this$vegaView._parser) === null || _this$vegaView$_parse === void 0 ? void 0 : _this$vegaView$_parse.restoreSignalValuesOnRefresh);
      }
    }));
    this.el = el;
    this.fireEvent = fireEvent;
  }
  async render(visData) {
    const {
      toasts
    } = (0, _services.getNotifications)();
    if (!visData && !this.vegaView) {
      toasts.addWarning(_i18n.i18n.translate('visTypeVega.visualization.unableToRenderWithoutDataWarningMessage', {
        defaultMessage: 'Unable to render without data'
      }));
      return;
    }
    try {
      await this._render(visData);
    } catch (error) {
      if (this.vegaView) {
        this.vegaView.onError(error);
      } else {
        toasts.addError(error, {
          title: _i18n.i18n.translate('visTypeVega.visualization.renderErrorTitle', {
            defaultMessage: 'Vega error'
          })
        });
      }
    }
  }
  async _render(vegaParser) {
    if (vegaParser) {
      var _vegaParser$searchAPI, _this$vegaView2;
      (_vegaParser$searchAPI = vegaParser.searchAPI.inspectorAdapters) === null || _vegaParser$searchAPI === void 0 ? void 0 : _vegaParser$searchAPI.vega.clearError();
      // New data received, rebuild the graph
      if (this.vegaView) {
        await this.vegaView.destroy();
        this.vegaView = null;
      }
      const serviceSettings = await getServiceSettings();
      const {
        filterManager
      } = this.dataPlugin.query;
      const {
        timefilter
      } = this.dataPlugin.query.timefilter;
      const vegaViewParams = {
        externalUrl: core.http.externalUrl,
        parentEl: this.el,
        fireEvent: this.fireEvent,
        vegaStateRestorer: this.vegaStateRestorer,
        vegaParser,
        serviceSettings,
        filterManager,
        timefilter,
        renderMode
      };
      if (vegaParser.useMap) {
        const {
          VegaMapView
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vega_view/vega_map_view/view')));
        this.vegaView = new VegaMapView(vegaViewParams);
      } else {
        const {
          VegaView: VegaViewClass
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vega_view/vega_view')));
        this.vegaView = new VegaViewClass(vegaViewParams);
      }
      await ((_this$vegaView2 = this.vegaView) === null || _this$vegaView2 === void 0 ? void 0 : _this$vegaView2.init());
    }
  }
  async resize(dimensions) {
    var _this$vegaView3;
    return (_this$vegaView3 = this.vegaView) === null || _this$vegaView3 === void 0 ? void 0 : _this$vegaView3.resize(dimensions);
  }
  destroy() {
    var _this$vegaView4;
    this.vegaStateRestorer.clear();
    (_this$vegaView4 = this.vegaView) === null || _this$vegaView4 === void 0 ? void 0 : _this$vegaView4.destroy();
  }
};
exports.createVegaVisualization = createVegaVisualization;